<?php $__env->startSection('title'); ?>
    Admin-Products
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Products
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-12">
        <?php if(session('product_msg')): ?>
            <?php if(session('product_msg') == 'true'): ?>
                <br>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Success! </strong> Reviews has been Deleted Successfully
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php else: ?>
                <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                    <strong> Failed! </strong> Some Issue Occured. Try Again
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        

        

        <div class="card">
            <div class="card-header"> Reviews</div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>
                            <th>Review
                            </th>

                            <th>Rating
                            </th>
                             <th>Date
                            </th>
                            <th >Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($review['id']); ?>

                                </td>
                                <td><?php echo e($review['name']); ?>

                                </td>
                                <td><?php echo e($review['review']); ?>

                                </td>

                                <td><?php echo e($review['stars']); ?> Stars
                                </td>
                                  <td><?php echo e(\Carbon\Carbon::parse($review->created_at)->diffForHumans()); ?>

                                </td>


                                <td>
                                    <a href="<?php echo e(route('delete_review', $review['id'])); ?>" class=""><i
                                            class="fad fa-trash"></i></a>


                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>


    </div>
</div>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
<?php $__env->stopSection(); ?>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/products/reviews.blade.php ENDPATH**/ ?>