<?php $__env->startSection('title'); ?>
    Admin-Product
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Product
<?php $__env->stopSection(); ?>

<div class="row">

    <div class="col-md-12">
        <div class="card">
            <?php if(session('color_msg')): ?>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> <?php echo e(session('color_msg')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>
            <div class="card-header">
                <h6> Product Colors</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-7">
                        <table class="table table-sm table-sm-responsive size-sm">
                            <tr>
                                <th>
                                    Color
                                </th>
                                <th>
                                    Code
                                </th>
                                <th>
                                    Visual
                                </th>
                                <th>
                                    Delete
                                </th>
                            </tr>
                            <?php $__currentLoopData = $product['getColors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($color->color); ?></td>
                                    <td><?php echo e($color->color_code); ?></td>
                                    <td><span class="py-0 px-3 size-vsm"
                                            style="color:<?php echo e($color->color_code); ?>;background-color:<?php echo e($color->color_code); ?>"></span>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('delete_color', $color->id)); ?>" class="deleteactionbtn"><i
                                                class="fad fa-trash"></i></a>

                                    </td>
                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>
                    <div class="col-md-5">
                        <form method="POST" action="<?php echo e(route('submit_color')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($product->code); ?>" name="product">
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Color Name:</label>
                                <input type="text" name="name" class="form-control ctextfield size-sm"
                                    placeholder="Name..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Color Hash Code:</label>
                                <input type="text" name="code" class="form-control ctextfield size-sm"
                                    placeholder="Code...">
                            </div>
                            <div class="form-group mt-3">
                                <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <?php if(session('size_msg')): ?>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> <?php echo e(session('size_msg')); ?>

                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>
            <div class="card-header">
                <h6> Product Sizes</h6>
            </div>
            <div class="card-body">




                    <div class="row">
                        <div class="col-md-7">
                            <table class="table table-sm table-sm-responsive size-sm">
                                <tr>
                                    <th>
                                        Sr.
                                    </th>
                                    <th>
                                        Size
                                    </th>
                                     <th>
                                        Quantity
                                    </th>
                                    <th>
                                        Delete
                                    </th>
                                </tr>
                                <?php $count=1;?>
                                <?php $__currentLoopData = $product['getSizes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php echo e($count++); ?>

                                        </td>

                                        <td>
                                            <?php echo e($size['size']); ?>

                                        </td>
                                         <td>
                                            <?php echo e($size['quantity']); ?>

                                        </td>

                                        <td>
                                            <a href="<?php echo e(route('delete_size', $size->id)); ?>" class="deleteactionbtn"><i
                                                    class="fad fa-trash"></i></a>
                                                     <a  data-toggle="modal" data-target="#exampleModal<?php echo e($size->id); ?>" class=""><i
                                                class="fad fa-edit"></i></a>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="exampleModal<?php echo e($size->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                          <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                              <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Edit Quantity</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                  <span aria-hidden="true">&times;</span>
                                                </button>
                                              </div>
                                              <div class="modal-body">
                                                 <form method="POST" action="<?php echo e(route('submit_size')); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" value="<?php echo e($size->id); ?>" name="size_id">
                                                         <input type="hidden" value="edit" name="type">
                                                        <div class="form-group mt-3">
                                                            <label class="size-nm text-muted">Size</label>
                                                            <input type="text" name="size" value="<?php echo e($size['size']); ?>" class="form-control ctextfield size-sm"
                                                                placeholder="Size..." required>
                                                        </div>
                                                          <div class="form-group mt-3">
                                                            <label class="size-nm text-muted">Quantity</label>
                                                            <input type="text" name="quantity" value="<?php echo e($size['quantity']); ?>" class="form-control ctextfield size-sm"
                                                                placeholder="Quantity..." required>
                                                        </div>

                                                        <div class="form-group mt-3">
                                                            <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                                                        </div>
                                                    </form>
                                              </div>

                                          </div>
                                        </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>

                        <div class="col-md-5">
                            <form method="POST" action="<?php echo e(route('submit_size')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" value="<?php echo e($product->code); ?>" name="product">
                                <div class="form-group mt-3">
                                    <label class="size-nm text-muted">Size</label>
                                    <input type="text" name="size" class="form-control ctextfield size-sm"
                                        placeholder="Size..." required>
                                </div>
                                  <div class="form-group mt-3">
                                    <label class="size-nm text-muted">Quantity</label>
                                    <input type="text" name="quantity" class="form-control ctextfield size-sm"
                                        placeholder="Quantity..." required>
                                </div>

                                <div class="form-group mt-3">
                                    <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                                </div>
                            </form>
                        </div>
                    </div>







            </div>
        </div>

        <div class="card">
            <?php if(session('unit_msg')): ?>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Message! </strong> <?php echo e(session('unit_msg')); ?>

                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>
            <div class="card-header">
                <h6> Product Units</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-7">
                        <table class="table table-sm table-sm-responsive size-sm">
                            <tr>
                                <th>
                                    Sr.
                                </th>
                                <th>
                                    Unit
                                </th>
                                <th>
                                    Price
                                </th>
                                <th>
                                    Show At Main
                                </th>
                                <th>
                                    Discount
                                </th>
                                <th>
                                    Final Price
                                </th>
                                <th>
                                    Action
                                </th>
                            </tr>
                            <?php $count=1;?>
                            <?php $__currentLoopData = $product['get_units']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e($count++); ?>

                                    </td>

                                    <td>
                                        <?php echo e($unit['unit']); ?>

                                    </td>
                                    <td>
                                        <?php echo e($unit['price']); ?>

                                    </td>
                                    <td>
                                        <?php echo e($unit['is_visible_main_price']); ?>

                                    </td>
                                    <td>
                                        <?php echo e($unit['discount']); ?>%
                                    </td>
                                    <td>
                                        <?php echo e($unit['final_price']); ?>

                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('delete_unit', $unit->id)); ?>" class="deleteactionbtn"><i
                                                class="fad fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>

                    <div class="col-md-5">
                        <form method="POST" action="<?php echo e(route('submit_unit')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($product->code); ?>" name="product">
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Unit</label>
                                <input type="text" name="unit" class="form-control ctextfield size-sm"
                                    placeholder="Unit..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Price</label>
                                <input type="text" name="price" class="form-control ctextfield size-sm"
                                    placeholder="Price..." required>
                            </div>
                            <div class="form-group mt-3">
                                <label class="size-nm text-muted">Visible At Main Price</label>
                                <select name="visible" class="form-control">
                                    <option value="">Select One</option>
                                    <option value="yes">yes</option>
                                    <option value="no">No</option>
                                </select>
                            </div>

                            <div class="form-group mt-3">
                                <input type="submit" name="submit_color" class="btn btn-sm btn-primary p-1 form-control">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>






</div>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
<?php $__env->stopSection(); ?>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/products/add_product_desc.blade.php ENDPATH**/ ?>