<?php $__env->startSection('title', 'Orders'); ?>
<?php $__env->startSection('stylesheet'); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('body'); ?>


<main class="bg_gray">

			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-xl-7 col-lg-9 ">
						<img src="<?php echo e(asset('static/images/track.jpeg')); ?>" alt="" class="img-fluid add_bottom_15" width="300" height="200">
						<p>Quick Tracking Order</p>
						<form method="get">
							<div class="search_bar">
								<input type="text" class="form-control" name="order" placeholder="Invoice ID">
								<input type="submit" value="Search" value="Get Detail">
							</div>
						</form>
					</div>
				</div>
				<!-- /row -->
			</div>
			<!-- /container -->

</main>



    <div class="container ">
        <div class="row">
            
            <div class="col-md-12 ">
                <?php if(session("alert")): ?>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                <strong> Success! </strong> Your Order has been placed.
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
                <?php endif; ?>
                <?php if(isset($order)): ?>
                <div class="blockdiv p-3 " style="border:1px solid grey">

                    <h5 class="text-center">ORDER DETAIL <hr></h5>
                    <table class="table table-sm table-sm-repsonsive">
                        <tr>
                            <td width="33%">
                                <label class="text-muted size-sm">Order No:</label>
                                <h6 class="size-nm"><?php echo e($order['order_no']); ?></h6>
                            </td>
                            <td width="33%">
                                <label class="text-muted size-sm">Date:</label>
                                <h6 class="size-nm"><?php echo e(date('d M Y H:i A',$order->created_at->timestamp)); ?></h6>
                            </td>

                            <td>
                                <label class="text-muted size-sm">Status</label>
                                <h6 class="size-nm"><?php echo e($order->status); ?></h6>
                            </td>

                        </tr>
                        <tr>
                            <th colspan="3"><br>Customer Information:</th>
                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">First Name:</label>
                                <h6 class="size-nm"><?php echo e($order->name); ?></h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Last Name:</label>
                                <h6 class="size-nm"><?php echo e($order->last_name); ?></h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Email</label>
                                <h6 class="size-nm"><?php echo e($order->email); ?></h6>
                            </td>

                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">Phone</label>
                                <h6 class="size-nm"><?php echo e($order->phone); ?></h6>
                            </td>

                            <td>
                                <label class="text-muted size-sm">Country</label>
                                <h6 class="size-nm"><?php echo e($order->country); ?></h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">State</label>
                                <h6 class="size-nm"><?php echo e($order->state); ?></h6>
                            </td>



                        </tr>
                        <tr>

                            <td>
                                <label class="text-muted size-sm">Street</label>
                                <h6 class="size-nm"><?php echo e($order->street); ?></h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Postal Code:</label>
                                <h6 class="size-nm"><?php echo e($order->postal_code); ?></h6>
                            </td>

                        </tr>
                        <tr>
                            <th colspan="3"><br>Delivery Details:</th>
                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">Tracking Number:</label>
                                <h6 class="size-nm"><?php echo e($order->tracking_number); ?></h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Delivery Through</label>
                                <h6 class="size-nm"><?php echo e($order->delivery_through); ?></h6>
                            </td>


                        </tr>
                        <tr>
                            <th colspan="3"><br>Order Products :</th>
                        </tr>


                    </table>
                    <table class="table table-sm table-sm-repsonsive size-sm">
                        <tr>
                            <th width="70%">
                                Product
                            </th>
                            <th>
                                Pack Size
                            </th>
                            <th>
                                Quantity
                            </th>
                            <th>
                                Price
                            </th>
                        </tr>
                        <?php $__currentLoopData = $order->getProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <h6 class="size-nm"><img src="<?php echo e(asset($product->photo)); ?>" class="logo-nm" >
                                 <?php echo e($product->name); ?>  <?php echo e($product->pivot->size); ?> <?php echo e($product->pivot->color); ?>  </h6>
                            </td>
                              <td>
                                <?php echo e($product->unit); ?>

                            </td>
                            <td>
                                <?php echo e($product->pivot->quantity); ?>

                            </td>

                            <td><?php echo e($product->pivot->total_amount); ?>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <th></th>
                            <th >
                               Total:
                            </th>
                            <th>
                                $<?php echo e($order->total_price); ?> USD
                            </th>
                        </tr>
                    </table><br>
                    <hr>
                    <h6 class="mb-3 text-center ctext"> <img src="<?php echo e(asset('static/images/main1.png')); ?>" style="width:140px;height:80px"></h6>

                </div>
                <?php else: ?>
                
                <?php endif; ?>
            </div>

        </div>
        <div class="row">

        </div>
    </div>
    <br>
    <br>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('user.usermaster2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel Projects\test store\18 jan backup (1)\resources\views/user/orders.blade.php ENDPATH**/ ?>