@extends('user.usermaster2')

@section('title', 'Products')

@section('meta_title') Products @endsection
@section('meta_keywords') PainFree, Adjustable Knee Sleeve, Compression Ankle Brace, Copper Hand and Wrist Support, Back
    Support Brace, Posture Corrector Clavicle Support, Foot Compression Sleeve, Magnetic Arthritis Gloves, Ankle Wrap
    Support, Abdominal Binder Belt, Plantar Fasciitis Compression Socks, Shoulder Brace Back Support, Knee Arthritis
    Compression Sleeve, Hand Compression Sleeve, Hernia Belt Support, Adjustable Foot and Ankle Splint, Compression Knee
    Support, Ankle Brace Stabilizer, Night Splint Socks, Arthritis Knee Brace, Wrist Pain Support, Knee Sleeve, Shoulder
    Support, Compression Ankle Sleeves, Adjustable Posture Corrector Back Support, Wrist Stabilizer, Foot Compression Socks,
    Ankle Compression Socks, Arthritis Knee Sleeve, Compression Gloves, Posture Corrector, Ankle Support, Knee Brace, Knee
    Patella Support, Patella Gel Pad, Ankle Compression Sleeve, Ankle Strap Support, Foot Stretching Socks, Ankle Brace
    Stabilizer Ankle Support, Anti-Fatigue Socks, Anti-Fatigue Compression Socks, Leg Ease Compression Socks, Arthritis
    Gloves, Magnetic Gloves, Copper Wrist and Hand Compression Sleeve, Waist Belt, Medical Umbilical Hernia Belt, United
    States PainFree, PainFree United States, PainFree United States Products, PainFree Products, PainFree United States,
Best PainFree United States, Best PainFree United States Products, Best PainFree Products. @endsection

@section('stylesheet')

@endsection


@section('body')
    <div class="top_banner">
        <div class="opacity-mask d-flex align-items-center" data-opacity-mask="rgba(0, 0, 0, 0.3)">
            <div class="container">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li><a href="#">Shop</a></li>

                    </ul>
                </div>
                <h1>New Arrival</h1>
            </div>
        </div>
        <img src="{{ asset('static/banners/products_bg.jpg') }}" class="img-fluid" alt="">
    </div>
    <div id="stick_here"></div>
    <div class="toolbox elemento_stick">
        <div class="container">
            <ul class="clearfix">
                <li>
                    <div class="sort_select">
                        <select name="sort" id="sort">
                            <option value="" @if (empty($sorting ?? '')) selected @endif>Choose Sorting Option
                            </option>
                            <option value="alphabetic_asc" @if (($sorting ?? '') == 'alphabetic_asc') selected @endif>Alphabetic - A
                                to Z</option>
                            <option value="alphabetic_desc" @if (($sorting ?? '') == 'alphabetic_desc') selected @endif>Alphabetic - Z
                                to A</option>
                            <option value="price_asc" @if (($sorting ?? '') == 'price_asc') selected @endif>Price - Low to High
                            </option>
                            <option value="price_desc" @if (($sorting ?? '') == 'price_desc') selected @endif>Price - High to Low
                            </option>
                            <option value="date_asc" @if (($sorting ?? '') == 'date_asc') selected @endif>Date Old to New
                            </option>
                            <option value="date_desc" @if (($sorting ?? '') == 'date_desc') selected @endif>Date New to Old
                            </option>
                        </select>
                    </div>
                </li>
                {{-- <li>
                    <a href="#0"><i class="ti-view-grid"></i></a>
                    <a href="listing-row-1-sidebar-left.html"><i class="ti-view-list"></i></a>
                </li> --}}
                <li>
                    <a href="#0" class="open_filters">
                        <i class="ti-filter"></i><span>Filters</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <div class="container margin_60_35">

        <div class="row small-gutters">
            <aside class="col-lg-3" id="sidebar_fixed">
                <div class="filter_col">
                    <div class="inner_bt"><a href="#" class="open_filters"><i class="ti-close"></i></a></div>
                    <div class="filter_type version_2">
                        <h4><a href="#filter_1" data-toggle="collapse" class="opened">Categories</a></h4>
                        <div class="collapse show" id="filter_1">
                            <ul>
                                <li>
                                    <label class="container_check"> All <small></small>
                                        <input type="radio" name="category" id="allCategory"
                                            @if (!isset($parameters['category'])) checked @endif>
                                        <span class="checkmark"></span>
                                    </label>
                                </li>
                                @foreach ($categories as $category)
                                    <li>
                                        <label class="container_check"> {{ Str::upper($category->name) }} <small></small>
                                            <input type="radio" name="category"
                                                @if (isset($parameters['category']) && $parameters['category'] == $category->code) checked @endif
                                                data-category-id="{{ $category->code }}">
                                            <span class="checkmark"></span>
                                        </label>
                                    </li>
                                @endforeach

                            </ul>
                        </div>
                        <!-- /filter_type -->
                    </div>


                </div>
            </aside>
            <div class="col-lg-9">
                <div class="row small-gutters">
                    <x-productcards :products=$products />
                </div>
            </div>

        </div>
        <div class="row">
            <div class="col-md-6 offset-md-6">
                {{ $products->links() }}
            </div>
        </div>
        <!-- /row -->
    </div>
    <!-- /container -->
    <div class="feat">
        <div class="container">
            <ul>
                <li>
                    <div class="box">
                        <i class="ti-gift"></i>
                        <div class="justify-content-center">
                            <h3>Free And Fast Delivery</h3>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="box">
                        <i class="ti-wallet"></i>
                        <div class="justify-content-center">
                            <h3>Secure Payment</h3>
                            <p>100% secure payment</p>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="box">
                        <i class="ti-headphone-alt"></i>
                        <div class="justify-content-center">
                            <h3>24/7 Support</h3>
                            <p>Online top support</p>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>


@endsection

@section('scripts')
    <script>
        // $('.pimage').removeClass('error');
        $("#sort_by").change(function() {
            //  alert("hello");
            if ($("#sort_by").val() != "") {
                // alert("hello");
                $("#submit_btn").click();
            }
        });

        $(document).ready(function() {
            $('input[type="radio"]').on('change', function() {
                // Get the selected category ID
                var categoryId = $(this).data('category-id');

                // Check if the "All" option is selected
                if ($(this).attr('id') === 'allCategory') {
                    // Redirect to the URL without the category parameter
                    window.location.href = '/shop';
                } else {
                    // Construct the URL for the route with the selected category ID
                    var routeUrl = '/shop/' + categoryId;
                    // Redirect to the route URL
                    window.location.href = routeUrl;
                }
            });


            $('#sort').on('change', function() {
                // Get the selected sorting option
                var selectedOption = $(this).val();

                // Get the current URL
                var currentUrl = window.location.href;

                // Check if the current URL already contains a query string
                var separator = currentUrl.includes('?') ? '&' : '?';

                // Check if the sort_by parameter is already present in the URL
                if (currentUrl.includes('sort_by=')) {
                    // Replace the existing sort_by parameter with the new value
                    var newUrl = currentUrl.replace(/sort_by=[^&]*/, 'sort_by=' + selectedOption);
                } else {
                    // Append the new sort_by parameter to the URL
                    var newUrl = currentUrl + separator + 'sort_by=' + selectedOption;
                }

                // Redirect to the new URL
                window.location.href = newUrl;
            });
        });
    </script>

@endsection
