@extends('admin.adminmaster')
@section('title')
    Admin-Order
@endsection

@section('content')
@section('heading')
    Order
@endsection
@if (session('order_change_status'))
    <div class="alert alert-info alert-dismissible fade show size-nm" role="alert">
        <strong> Message </strong>{{ session('order_change_status') }}
        <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

    <div class="row">
        <div class="col-md-3">
            <button type="button" class="btn btn-md btn-primary " data-toggle="modal" data-target="#exampleModal">
                Add Delivery Details
            </button>
        </div>
    </div>
    <div class="row mt-2">

        <div class="col-md-4">

            <div class="card ">
                <div class="card-header">
                    <h6> Change Order Status </h6>
                </div>
                <div class="card-body">
                    <form method="post" action="{{ route('update_order_status') }}">
                        @csrf
                        <h6 class="size-nm"> Order Status:</h6>
                        <input type="hidden" name="oid" value="{{ $order->order_no }}">
                        <select name="status" class="form-control ctextfield size-nm" required>
                            <option value="">Choose Order Status</option>
                            <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>Accept
                            </option>
                            <option value="rejected" {{ $order->status == 'rejected' ? 'selected' : '' }}>Reject
                            </option>
                            <option value="completed" {{ $order->status == 'completed' ? 'selected' : '' }}>Completed
                            </option>
                            <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>Pending</option>
                        </select>
                        <br>
                        <button type="submit" class="btn btn-sm form-control btn-success size-nm">CHANGE ORDER STATUS</button>
                    </form>

                </div>


            </div>

            <button class="btn btn-sm form-control btn-primary size-nm" onclick="printInvoice()">PRINT ORDER INVOICE</button>
        </div>

        <div class="col-md-8 ">
            @if (isset($order))
                <div id="invoice">
                    <div class="blockdiv p-3 bg-light" style="border:1px solid grey">

                        <h5 class="text-center">ORDER INVOICE

                        </h5>
                        <table class="table table-sm table-sm-repsonsive">
                            <tr>
                                <td width="23%">
                                    <label class="text-muted size-sm">Order No:</label>
                                    <h6 class="size-nm">{{ $order['order_no'] }}</h6>
                                </td>
                                <td width="23%">
                                    <label class="text-muted size-sm">Date:</label>
                                    <h6 class="size-nm">{{ date('d M Y H:i A',$order->created_at->timestamp) }}</h6>
                                </td>

                                <td>
                                    <label class="text-muted size-sm">Status</label>
                                    <h6 class="size-nm">{{ ucfirst( $order->status) }}</h6>
                                </td>

                                <td>
                                    <label class="text-muted size-sm">Payment Status</label>
                                    <h6 class="size-nm">{{ ucfirst($order->payment_status ) }}</h6>
                                </td>
                            </tr>
                            <tr>
                                <th colspan="4"><br>Customer Information:</th>
                            </tr>
                            <tr>
                                <td>
                                    <label class="text-muted size-sm">First Name:</label>
                                    <h6 class="size-nm">{{ $order->name }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Last Name:</label>
                                    <h6 class="size-nm">{{ $order->last_name }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Email</label>
                                    <h6 class="size-nm">{{ $order->email }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Phone</label>
                                    <h6 class="size-nm">{{ $order->phone }}</h6>
                                </td>


                            </tr>
                            <tr>

                                <td>
                                    <label class="text-muted size-sm">State</label>
                                    <h6 class="size-nm">{{ $order->state }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Country</label>
                                    <h6 class="size-nm">United States</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Street</label>
                                    <h6 class="size-nm">{{ $order->street }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Postal Code:</label>
                                    <h6 class="size-nm">{{ $order->postal_code }}</h6>
                                </td>

                            </tr>
                            <tr>
                                <th colspan="3"><br>Delivery Details:</th>
                            </tr>
                            <tr>
                                <td>
                                    <label class="text-muted size-sm">Tracking Number:</label>
                                    <h6 class="size-nm">{{ $order->tracking_number }}</h6>
                                </td>
                                <td>
                                    <label class="text-muted size-sm">Delivery Through</label>
                                    <h6 class="size-nm">{{ $order->delivery_through }}</h6>
                                </td>
                                <td></td>
                                <td></td>


                            </tr>
                            <tr>
                                <th colspan="3"><br>Order Products :</th>
                            </tr>


                        </table>
                        <table class="table table-sm table-sm-repsonsive size-sm">
                            <tr>
                                <th width="70%">
                                    Product
                                </th>
                                <th>
                                    Pack Size
                                </th>
                                <th>
                                    Quantity
                                </th>
                                <th>
                                    Price
                                </th>
                            </tr>
                            @foreach ($order->getProducts as $product)
                                <tr>
                                    <td>
                                        <h6 class="size-nm"><img src="{{ asset($product->photo) }}" class="logo-nm">
                                            {{ $product->name }} - {{ $product->pivot->size }}
                                            {{ $product->pivot->color }} </h6>
                                    </td>
                                    <td>
                                        {{ $product->pivot->unit  }}
                                    </td>
                                    <td>
                                        {{ $product->pivot->quantity }}
                                    </td>
                                    <td>{{ $product->pivot->total_amount }}
                                    </td>
                                </tr>
                            @endforeach

                            <tr>
                                <th></th>
                                <th>
                                    Total:
                                </th>
                                <th>
                                    ${{ $order->total_price }} USD
                                </th>
                            </tr>
                        </table><br>
                        <hr>
                        <h6 class="mb-3 text-center ctext"> <img src="{{ asset('static/images/main1.png') }}"
                                style="width:70px;height:40px"><br> PAIN FREE-USA</h6>
                        <p class="text-muted size-nm text-end mt-3">Signature: -------------------</p>

                    </div>
                @else
                    <h5 class="ctext text-center">No Result</h5>
            @endif
        </div>
    </div>





<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Detail</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="{{ route('add_delivery_detail') }}">

                    @csrf
                    <input type="hidden" name="oid" value="{{ $order->order_no }}">
                    <h6 class="size-nm"> Tracking Number:</h6>
                    <input type="text" name="tid" class="form-control" placeholder="i.e: 5115985">
                    <h6 class="size-nm"> Delivery Through:</h6>
                    <input type="text" name="d_thr" class="form-control" placeholder="i.e: DHL or Tcs">

                    <br>
                    <button type="submit" class="btn btn-sm form-control btn-primary size-nm">Submit</button>
                </form>
            </div>
            {{-- <div class="modal-footer">

          <button type="button" class="btn btn-primary">Save changes</button>
        </div> --}}
        </div>
    </div>
</div>





@endsection
@section('script')
    <script type="text/javascript">
        $("#sideorder").addClass("sidelinkactive");

        function printInvoice() {
            var backup = $("body").html();
            var content = $("#invoice").html();
            $("body").html(content);
            window.print();
            $("body").html(backup);
        }
    </script>
@endsection
