@extends('admin.adminmaster')
@section('title')
    Dashboard
@endsection
@section('style')
    <style>
        .dashdiv {
            background-color: white;
            border-radius: 10px 10px;
            height: 120px;
            margin: 10px 20px;
            padding: 15px 15px;
        }

        .header {
            margin: 0px 0px;
            margin-top: -24px;
            padding-bottom: 30px;


        }

        .dashhead {
            font-size: 26px;
            font-weight: 350;
        }

        .pendingorders,
        .orders {
            max-height: 600px;
            overflow: auto;
        }
    </style>
@endsection


@section('content')

<div class="row">
    <div class="col md-12">
        <div class="card mb-3">
            <div class="card-header">
                <h2 class="">Dashboard</h2>
            </div>
            <div class="card-body">


                    <div class="row p-0">
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Total Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#{{ $total_orders }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Total Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">${{ round($total_payments,2) }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Today Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#{{ $today_orders }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Today Orders Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">{{ $today_payments }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">This Month Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#{{ $month_orders }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Monthly Orders Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">{{ $month_payments }}</h2>

                                    </div>
                                </div>
                            </div>
                        </div>



                    </div>

            </div>
        </div>
        <div class="card mb-2">
            <div class="card-header">
                This Month's Graph
            </div>
            <div class="card-body">
                        <canvas id="myChart" style="width:100%;"></canvas>

            </div>
        </div>
       
        <div class="btn-group text-right d-block" role="group" aria-label="Basic example">

            <a href="{{ route('admin_orders') }}" class="btn btn-sm btn-primary float-end ">View All</a>
        </div>
        <div class="card" id="order">

            <div class="card-header">
                <h4>Latest Orders</h4>
            </div>
            <div class="card-body">
                   <form method="GET" class="m-3">
                       <div class="row">
                           <div class="col-md-3">
                               <input type="text" name="id" placeholder="Search By Id" value="{{ $inputs['id'] ?? '' }}">
                           </div>
                             <div class="col-md-3">
                               <input type="text" name="name" placeholder="Search By Name" value="{{ $inputs['name'] ?? '' }}">
                           </div>
                             <div class="col-md-3">
                               <input type="date" name="date" value="{{ $inputs['date'] ?? '' }}">
                           </div>
                             <div class="col-md-3">
                              <input type="submit" value="Search" class="btn btn-sm btn-primary">
                              <a href="{{route('dashboard')}}" class="btn btn-sm btn-light">Show All</a>
                           </div>
                       </div>
                   </form>
                <table  class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Price
                            </th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Placed At
                            </th>
                            <th>Status
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($orders_list as $order)
                            <tr>
                                <td>{{ $order['order_no'] }}
                                </td>
                                <td>{{ $order['total_price'] }} USD
                                </td>
                                <td>{{ $order['name'] }}
                                </td>
                                <td>{{ $order['phone'] }}
                                </td>

                                <td>{{ $order['created_at'] }}
                                </td>
                                <td>{{ $order['status'] }}
                                </td>

                                <td>
                                    <a href={{ route('admin_order_detail', $order->order_no) }} class="editactionbtn"><i
                                            class="fad fa-edit"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                  {!! $orders_list->links() !!}
            </div>
        </div>
    </div>
</div>

    {{-- <div class="bottomsection mt-3">
        <h6 class="px-3 mb-2">Pending Orders:</h6>

        <hr>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 orders ">
                   <br>
                    <table id="maintbl" class="maintbl table table-sm table-sm-responsive size-nm table-hover ">
                        <thead>
                            <tr>
                                <th>ID
                                </th>
                                <th>Price
                                </th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Placed At
                                </th>
                                <th>Status
                                </th>
                                <th width="10%">Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($orders_list as $order)
                                <tr>
                                    <td>{{ $order['order_no'] }}
                                    </td>
                                    <td>{{ $order['total_price'] }} AUD
                                    </td>
                                    <td>{{ $order['name'] }}
                                    </td>
                                    <td>{{ $order['phone'] }}
                                    </td>

                                    <td>{{ $order['created_at'] }}
                                    </td>
                                    <td>{{ $order['status'] }}
                                    </td>

                                    <td>
                                        <a href={{ route('admin_order_detail', $order->order_no) }} class="editactionbtn"><i
                                                class="fad fa-edit"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div> --}}
@section('script')
<script
src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js">
</script>
    <script type="text/javascript">
        $("#sideorder").addClass("sidelinkactive");
    </script>
    <script>
        var xValues = [50,60,70,80,90,100,110,120,130,140,150];
var yValues = [7,8,8,9,9,9,10,11,14,14,15];
yValues = @json($days_amount);
xValues = @json($days);
new Chart("myChart", {
  type: "line",
  data: {
    labels: xValues,
    datasets: [{
        label: 'Amount AUD ',
      borderColor: "rgba(0,0,255,0.1)",
      data: yValues
    }]
  }
});


$('#datatable').dataTable( {
  "pageLength": 50
} );
    </script>
    
    
     <script>
  $(document).ready(function() {
    // Assuming you have the value in the 'scrollToOrder' variable
    var scrollToOrder = @json($inputs); // Replace 'true' with your actual variable containing the value

    // Check if the 'scrollToOrder' variable has a value
    if (scrollToOrder!="") {
      // Scroll to the div with ID 'order'
      $('html, body').animate({
        scrollTop: $('#order').offset().top // Scroll to the top position of the 'order' div
      }, 1000); // Adjust the duration as per your preference (1000ms = 1 second)
    }
  });
</script>
    
   
    
 
    
    
    
@endsection


@endsection
