@extends("admin.adminmaster")
@section("title") Admin-Customers @endsection

@section("content")
@section("heading") Customers @endsection

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h6> View Customers </h6>
            </div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                    <tr>
                        <th>Image
                        </th>
                        <th>ID
                        </th>
                        <th> Name
                        </th>

                         <th>Email
                        </th>
                        <th>Phone
                        </th>
                        <th>City
                        </th>

                      <th>
                         Status
                      </th>

                      <th>Action
                      </th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($customers as $customer)
                     <tr>
                        <td><img src="{{asset($customer['image'])}}" class="img img-fluid logo-nm">
                        </td>
                        <td>{{$customer['id']}}
                        </td>
                        <td>{{$customer['name']}}
                        </td>

                        <td>{{$customer['email']}}
                        </td>
                        <td>{{$customer['phone']}}
                        </td>
                        <td>{{ $customer['city'] }}</td>

                        <td>{{$customer['status']}}
                        </td>

                        <td >
                            <a href="" class="editactionbtn"><i class="fad fa-edit"></i></a> |
                            <a href="" class="deleteactionbtn"><i class="fad fa-trash"></i></a>
                        </td>
                    </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>


</div>
@section("script")

<script type="text/javascript">
	$("#sidecust").addClass("sidelinkactive");
</script>
@endsection




@endsection
