<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\product;
class ProductFactory extends Factory
{
    protected $model=product::class;
    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            //
            'name' => $this->faker->name(),
            'code' => str_replace(" ","",$this->faker->unique()->name()),
            'discount'=>'0',
            'final_price'=>110,
            'price'=>110,
            'status'=>'public',
            'photo'=>$this->faker->randomElement(['static/images/bag2.png','static/images/knee.jpeg','static/images/bag.jpg']),
            'category_id'=>4,
            'gender'=>$this->faker->randomElement(['male','female','both']),
            'terms_conditions'=>$this->faker->text(),
            'short_description'=>$this->faker->text(),
            'description'=>$this->faker->text(),
        ];

        // $table->string("code")->unique();
        // $table->float("price")->nullable();
        // $table->float("discount")->nullable();
        // $table->string("final_price")->nullable();
        // $table->enum("status",['public','private'])->nullable();
        // $table->string("photo",300)->nullable();
        // $table->bigInteger("category_id")->unsigned()->nullable();
        // $table->foreign("category_id")->references("id")->on("categories")->onDelete("cascade");
        // $table->enum("gender",['male','female','both'])->nullable();
        // $table->string("terms_conditions")->nullable();
        // $table->string("short_description")->nullable();
        // $table->string("description",1000)->nullable();
    }
}
