<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\poster;

class PosterController extends Controller
{
    //
    public function posters()
    {
        return view("admin.posters.posters",['posters'=>poster::all()]);
    }
    public function addposter()
    {
        return view("admin.posters.addposter");
    }
    public function saveposter(Request $req)
    {
        $req->validate(['title'=>'required|min:2|max:40',
        'tag1'=>'required|max:100','tag2'=>'max:100','description'=>'max:299','status'=>'required']);
        $poster=new poster();
        $poster->title=$req->input("title");
        $poster->tag1=$req->input("tag1");
        $poster->tag2=$req->input("tag2");
        $poster->status=$req->input("status");
        $poster->description=$req->input("description");
        if($req->file("photo")!="")
        {
            $file=$req->file("photo");
            $extension=$req->file("photo")->getClientOriginalExtension();
            $filename=time().".".$extension;
            $file->move("dynamic/posters/",$filename);
            $poster->photo="dynamic/posters/".$filename;
        }

        if($poster->save())
        {
            $req->session()->flash("poster_msg","true");
            return redirect()->back();
        }
        else
        {
            $req->session()->flash("poster_msg","false");
            return redirect()->back();
        }

    }
    public function deleteposter($id)
    {
        $poster=poster::where('id',$id)->delete();

       // $product->delete();
        return redirect()->back();
    }
}
