<?php

namespace App\Http\Classes;

use Illuminate\Support\Facades\Http;

class CJApi
{
    private $email;
    private $password;
    private $baseUrl;

    public function __construct()
    {
        $this->email = env('CJ_EMAIL');
        $this->password = env('CJ_PASSWORD');
        $this->baseUrl = env('CJ_API_BASE_URL');
    }

    public function getToken()
    {
        $response = Http::post("{$this->baseUrl}/authentication/getAccessToken", [
            'email' => $this->email,
            'password' => $this->password,
        ]);

        $data = $response->json();

        if (isset($data['data']['accessToken'])) {
            return $data['data']['accessToken']; // Return the access token
        }

        return $data; // Return full response for debugging if token is not found
    }
    public function getProducts($request, $perPage = 20)
    {
        $accessToken = session('access_token');
        if (!$accessToken) {
            return ['error' => 'Access token not found'];
        }
        $page = $request->query('page', 1); // Default page = 1
        //$categoryId = $request->query('category') ?? '8E00C4BE-1E35-43E7-A891-6CAE58BB48CF'; // Get category ID from query

        $params = [
            'pageNum' => $page,
            'pageSize' => $perPage,
        ];

        if($request->query('name'))
        {
             $params['productNameEn'] = $request->query('name');
        }
        else{
             $categoryId = $request->query('category') ?? '8E00C4BE-1E35-43E7-A891-6CAE58BB48CF';
        }
        if( $request->query('category'))
        {
            $params['categoryId'] =$request->query('category');
        }
        

        $response = Http::withHeaders([
            'CJ-Access-Token' => $accessToken,
        ])->get("{$this->baseUrl}/product/list", $params);
        ///dd($response->json());
        return $data = $response->json();


    }
    public function getProductDetails($productId)
    {
        $accessToken = session('access_token');

        if (!$accessToken) {
            return ['error' => 'Access token not found'];
        }

        $response = Http::withHeaders([
            'CJ-Access-Token' => $accessToken,
        ])->get("{$this->baseUrl}/product/query", [
            'pid' => $productId,
        ]);

        return $response->json();
    }
}
