<?php $__env->startSection('title'); ?>
    Admin-Posters
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Posters
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-12">
        <div class="text-right mb-2">
            <a href="<?php echo e(route('addposter')); ?>" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i> Add
                New
                Poster</a>
        </div>
        <div class="card">
            <div class="card-header">
                <h6> View Posters </h6>
            </div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                <thead>
                    <tr>
                        <th>ID
                        </th>
                        <th>Title
                        </th>
                        <th>Tag 1
                        </th>
                        <th>Tag 2
                        </th>
                        <th>Status
                        </th>
                        <th>Image
                        </th>
                        <th width="10%">Action
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $posters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $poster): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($poster['id']); ?>

                            </td>
                            <td><?php echo e($poster['title']); ?>

                            </td>
                            <td><?php echo e($poster['tag1']); ?>

                            </td>
                            <td><?php echo e($poster['tag2']); ?>

                            </td>
                            <td><?php echo e($poster['status']); ?>

                            </td>
                            <td><img src="<?php echo e(asset($poster['photo'])); ?>" class="img img-fluid logo-nm">
                            </td>
                            <td>

                                <a href="<?php echo e(route('deleteposter',$poster['id'])); ?>" class="deleteactionbtn"><i
                                        class="fad fa-trash"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            </div>
        </div>
    </div>


</div>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $("#sideposter").addClass("sidelinkactive");
    </script>
<?php $__env->stopSection(); ?>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/posters/posters.blade.php ENDPATH**/ ?>