<?php $__env->startSection('title'); ?>
    Admin-Orders
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Orders
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">  <h6> View Orders </h6></div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
    <thead>
        <tr>
            <th>ID
            </th>
            <th>Price
            </th>
            <th>Name</th>
            <th>Phone</th>
            <th>Placed At
            </th>
            <th>Status
            </th>
            <th width="10%">Action
            </th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($order->status == 'pending'): ?>
                <tr class="alert-warning text-dark">
                <?php elseif($order->status == 'processing'): ?>
                <tr class="alert-info text-dark">
                <?php elseif($order->status == 'completed'): ?>
                <tr class="alert-success">
                <?php elseif($order->status == 'rejected'): ?>
                <tr class="alert-danger">
                <?php else: ?>
                <tr>
            <?php endif; ?>

            <td><?php echo e($order['order_no']); ?>

            </td>
            <td><?php echo e($order['total_price']); ?> USD
            </td>
            <td><?php echo e($order['name']); ?>

            </td>
            <td><?php echo e($order['phone']); ?>

            </td>

            <td><?php echo e($order['created_at']); ?>

            </td>
            <td><?php echo e($order['status']); ?>

            </td>

            <td>
                <a href=<?php echo e(route('admin_order_detail', $order->order_no)); ?> class="editactionbtn"><i
                        class="fad fa-edit"></i></a>
            </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
            </div>
        </div>
    </div>



</div>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $("#sideorder").addClass("sidelinkactive");
    </script>
<?php $__env->stopSection(); ?>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/orders/orders.blade.php ENDPATH**/ ?>