<?php $__env->startSection('title'); ?>
    Admin- Edit Product
<?php $__env->stopSection(); ?>
<?php $__env->startSection('heading'); ?>
    Edit Product
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h6> Edit Product </h6>
            </div>
            <div class="card-body">
                <a href="<?php echo e(route('product_description')); ?>?product=<?php echo e($product['code']); ?>"
                    class="btn btn-sm btn-info float-right m-3">Edit More Info</a>
                <br>
                <h6> Fill the Required Fields</h6>
                <?php if(session('product_msg')): ?>
                    <?php if(session('product_msg') == 'true'): ?>

                        <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                            <strong> Success! </strong> Product has been Edited Successfully
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                            <strong> Failed! </strong> Some Issue Occured. Try Again
                            <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>


                <form method="post" class="size-sm" action="<?php echo e(route('updateproduct')); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Name*: </h6>
                            </td>
                            <td>
                                <input type="text" id="name" name="name" min required
                                    value="<?php echo e($product['name']); ?>" class="form-control ctextfield size-nm"
                                    placeholder="Enter Product Title...">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Category* </h6>
                            </td>
                            <td>
                                <select name="category" id="category" class="form-control ctextfield size-sm" required>
                                    <option value="">Choose Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category['id']); ?>"
                                            <?php echo e($product['category_id'] == $category['id'] ? 'selected' : ''); ?>>
                                            <?php echo e($category['name']); ?> (<?php echo e($category['code']); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Price*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="price" name="price" value="<?php echo e($product['final_price']); ?>"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product price...">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>
                         <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Priority*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="priority" name="priority" value="<?php echo e($product['priority']); ?>"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Priority...">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Quantity*: </h6>
                            </td>
                            <td>
                                <input type="number"  id="quantity" name="quantity"
                                    value="<?php echo e($product['quantity']); ?>" class="form-control ctextfield size-nm"
                                    placeholder="Enter Product quantity...">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product For </h6>
                            </td>
                            <td>
                                <select name="gender" id="gender" class="form-control ctextfield size-sm" >
                                    <option value="">Choose Gender</option>
                                    <option value="male" <?php echo e($product['gender'] == 'male' ? 'selected' : ''); ?>>Male
                                    </option>
                                    <option value="female" <?php echo e($product['gender'] == 'female' ? 'selected' : ''); ?>>
                                        Female
                                    </option>
                                    <option value="uni_sex" <?php echo e($product['gender'] == 'uni_sex' ? 'selected' : ''); ?>>
                                        UniSex
                                    </option>
                                </select>
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>




                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Photo* </h6>
                            </td>
                            <td>
                                <input type="file" id="photo" name="photo" class="  size-nm"
                                    value="<?php echo e($product['photo']); ?>">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                                <input type="checkbox" name="image_change" value="true">
                                <span class="text-danger size-nm">Change Image</span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Description* </h6>
                            </td>
                            <td>
                                <textarea id="description" name="description"><?php echo $product['description']; ?></textarea>
                                <!--<textarea id="description" name="description">hello</textarea>-->

                                <span class="text-danger size-nm"> <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Meta Title*: </h6>
                            </td>
                            <td>
                                <input type="text"  name="meta_name" value="<?php echo e($product['meta_title']); ?>"
                                    class="form-control ctextfield size-nm" placeholder="Enter  Product Meta Title...">
                                <span class="text-danger size-nm"> <?php $__errorArgs = ['meta_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Meta Description* </h6>
                            </td>
                            <td>
                                <textarea id="meta_description"   rows="5" style="width: 100%" name="meta_description"><?php echo $product['meta_description']; ?></textarea>


                                <span class="text-danger size-nm"> <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <input type="hidden" value="<?php echo e($product['id']); ?>" name="id">
                            <td colspan="2" class="text-right">
                                <input type="submit" name="submit" class="btn btn-sm btn-primary cbtn float-end size-nm"
                                    value="SUBMIT">
                            </td>
                        </tr>



                    </table>




                </form>

            </div>
        </div>





    </div>



</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script type="text/javascript">
    $("#sideproducts").addClass("sidelinkactive");
    CKEDITOR.replace('description');

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/products/editproduct.blade.php ENDPATH**/ ?>