<?php $__env->startSection('title'); ?>
    Admin-Products
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php $__env->startSection('heading'); ?>
    Products
<?php $__env->stopSection(); ?>

<div class="row">
    <div class="col-md-12">
        <?php if(session('product_msg')): ?>
            <?php if(session('product_msg') == 'true'): ?>
                <br>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Success! </strong> Producthas been Deleted Successfully
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php else: ?>
                <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                    <strong> Failed! </strong> Some Issue Occured. Try Again
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            <?php endif; ?>
        <?php endif; ?>
        

        <div class="btn-group text-right d-block" role="group" aria-label="Basic example">

            <a href="<?php echo e(route('seller_discount_products')); ?>" class="btn btn-sm btn-warning  float-end"><i
                    class="far fa-tags"></i> Discount Products</a>
            <a href="<?php echo e(route('addproduct')); ?>" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i>
                Add
                New Product</a>
        </div>

        <div class="card">
            <div class="card-header">View Products</div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>
                            <th>Code
                            </th>

                            <th>Discount
                            </th>

                            <th>Price
                            </th>
                            <th>Image
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product['id']); ?>

                                </td>
                                <td><?php echo e($product['name']); ?>

                                </td>
                                <td><?php echo e($product['code']); ?>

                                </td>

                                <td><?php if($product['discount']>0): ?><?php echo e($product['discount']); ?>%<?php else: ?> N/A <?php endif; ?>
                                </td>
                                <td>$<?php echo e($product['final_price']); ?>

                                </td>

                                <td>

                                    <?php
                                        $rating = 0;
                                        $reviewCount = count($product->getReviews);

                                        foreach ($product->getReviews as $review) {
                                            $rating += $review->stars; // Assuming `star` is the attribute that stores the rating (e.g., 3, 4, or 5).
                                        }
                                        if ($rating > 0) {
                                            $rating = $rating / sizeof($product->getReviews);
                                        }

                                    ?>
                                    <?php echo e(round( $rating,1)); ?> stars

                                </td>

                                <td><img src="<?php echo e(asset($product['photo'])); ?>" class="img img-fluid logo-nm">
                                </td>
                                <td>

                                    <a href="<?php echo e(route('editproduct', $product['id'])); ?>" class=""><i
                                            class="fad fa-edit"></i></a> |
                                            <a href="<?php echo e(route('reviews', $product['id'])); ?>" class=""><i
                                                class="far fa-comment"></i></a> |
                                    <a href="<?php echo e(route('deleteproduct', $product['id'])); ?>" class=""><i
                                            class="fad fa-trash"></i></a> |
                                    <a href="<?php echo e(route('add_product_images', $product['id'])); ?>"
                                        class="deleteactionbtn"><i class="fa fa-eye"></i></a>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>


    </div>
</div>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
<?php $__env->stopSection(); ?>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/products/products.blade.php ENDPATH**/ ?>