
<?php $__env->startSection("title"); ?> Dashboard <?php $__env->stopSection(); ?>

<?php $__env->startSection("content"); ?>
<?php $__env->startSection("heading"); ?> Dashboard <?php $__env->stopSection(); ?>

<div class="card">
	<div class="card-header">
		Apply Filters
	</div>
	<div class="card-body">
		<div class="container-fluid">
			<form class="row mb-4" method="GET" >
				<div class="col-md-3">
					<label>Select Date:</label>
					<input type="date" name="date" value="<?php echo e(($filters['date'] ?? '' )); ?>" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Month:</label>
					<input type="number" min="1" max="12" name="month" value="<?php echo e(($filters['month'] ?? '' )); ?>" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Year:</label>
					<input type="number" min="2021" max="2099" name="year" value="<?php echo e(($filters['year'] ?? '' )); ?>" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Email of customer:</label>
					<input type="email" name="email" value="<?php echo e(($filters['email'] ?? '' )); ?>" class="form-control">
				</div>
				<div class="col-md-12 text-right mt-1">
					<button class="btn btn-sm btn-primary">Apply Filter</button>
					<!--<button class="btn btn-sm btn-md btn-secondary">Show Filter</button>-->

				</div>
			</form>
			
			<?php if($amount!=""): ?>
			    <label class="bg-primary size-nm badge mb-2 text-light py-2 px-2">Total Amount: (<?php echo e($amount); ?>)</label>
			    <label class="bg-secondary size-nm badge mb-2  text-light  py-2 px-2">Total Orders: (<?php echo e(sizeof($orders)); ?>)</label>

			<?php endif; ?>
				    <table id="datatable" class="maintbl table table-sm table-sm-responsive size-nm table-hover ">
                        <thead>
                            <tr>
                                <th>ID
                                </th>
                                <th>Price
                                </th>
                                <th>Name </th>
                                <th>Phone</th>
                                <th>Placed At
                                </th>
                                <th>Status
                                </th>
                                <th width="10%">Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($order['order_no']); ?>

                                    </td>
                                    <td><?php echo e($order['total_price']); ?> AUD
                                    </td>
                                    <td><?php echo e($order['name']); ?> <span class='text-muted'>(<?php echo e($order['email']); ?>) </span>
                                    </td>
                                    <td><?php echo e($order['phone']); ?>

                                    </td>

                                    <td><?php echo e($order['created_at']); ?>

                                    </td>
                                    <td><?php echo e($order['status']); ?>

                                    </td>

                                    <td>
                                        <a href=<?php echo e(route('admin_order_detail', $order->order_no)); ?> class="editactionbtn"><i
                                                class="fad fa-edit"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

		</div>
	</div>
</div>
	







<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
<script>
    $('#datatable').dataTable( {
  "pageLength": 50
} );
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make("admin.adminmaster", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/reports.blade.php ENDPATH**/ ?>