<?php $__env->startSection('title'); ?>
    Dashboard
<?php $__env->stopSection(); ?>
<?php $__env->startSection('style'); ?>
    <style>
        .dashdiv {
            background-color: white;
            border-radius: 10px 10px;
            height: 120px;
            margin: 10px 20px;
            padding: 15px 15px;
        }

        .header {
            margin: 0px 0px;
            margin-top: -24px;
            padding-bottom: 30px;


        }

        .dashhead {
            font-size: 26px;
            font-weight: 350;
        }

        .pendingorders,
        .orders {
            max-height: 600px;
            overflow: auto;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col md-12">
        <div class="card mb-3">
            <div class="card-header">
                <h2 class="">Dashboard</h2>
            </div>
            <div class="card-body">


                    <div class="row p-0">
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Total Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#<?php echo e($total_orders); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Total Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">$<?php echo e(round($total_payments,2)); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Today Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#<?php echo e($today_orders); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Today Orders Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0"><?php echo e($today_payments); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cube-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">This Month Orders</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0">#<?php echo e($month_orders); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <div class="card mini-stat m-b-30">
                                <div class="p-3 bg-primary text-white">
                                    <div class="mini-stat-icon">
                                        <i class="mdi mdi-cart-outline float-right mb-0"></i>
                                    </div>
                                    <h6 class="text-uppercase mb-0">Monthly Orders Amount</h6>
                                </div>
                                <div class="card-body">

                                    <div class="mt-4 text-muted">

                                        <h2 class=" float-right m-0"><?php echo e($month_payments); ?></h2>

                                    </div>
                                </div>
                            </div>
                        </div>



                    </div>

            </div>
        </div>
        <div class="card mb-2">
            <div class="card-header">
                This Month's Graph
            </div>
            <div class="card-body">
                        <canvas id="myChart" style="width:100%;"></canvas>

            </div>
        </div>
       
        <div class="btn-group text-right d-block" role="group" aria-label="Basic example">

            <a href="<?php echo e(route('admin_orders')); ?>" class="btn btn-sm btn-primary float-end ">View All</a>
        </div>
        <div class="card" id="order">

            <div class="card-header">
                <h4>Latest Orders</h4>
            </div>
            <div class="card-body">
                   <form method="GET" class="m-3">
                       <div class="row">
                           <div class="col-md-3">
                               <input type="text" name="id" placeholder="Search By Id" value="<?php echo e($inputs['id'] ?? ''); ?>">
                           </div>
                             <div class="col-md-3">
                               <input type="text" name="name" placeholder="Search By Name" value="<?php echo e($inputs['name'] ?? ''); ?>">
                           </div>
                             <div class="col-md-3">
                               <input type="date" name="date" value="<?php echo e($inputs['date'] ?? ''); ?>">
                           </div>
                             <div class="col-md-3">
                              <input type="submit" value="Search" class="btn btn-sm btn-primary">
                              <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-sm btn-light">Show All</a>
                           </div>
                       </div>
                   </form>
                <table  class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Price
                            </th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Placed At
                            </th>
                            <th>Status
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order['order_no']); ?>

                                </td>
                                <td><?php echo e($order['total_price']); ?> USD
                                </td>
                                <td><?php echo e($order['name']); ?>

                                </td>
                                <td><?php echo e($order['phone']); ?>

                                </td>

                                <td><?php echo e($order['created_at']); ?>

                                </td>
                                <td><?php echo e($order['status']); ?>

                                </td>

                                <td>
                                    <a href=<?php echo e(route('admin_order_detail', $order->order_no)); ?> class="editactionbtn"><i
                                            class="fad fa-edit"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                  <?php echo $orders_list->links(); ?>

            </div>
        </div>
    </div>
</div>

    
<?php $__env->startSection('script'); ?>
<script
src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js">
</script>
    <script type="text/javascript">
        $("#sideorder").addClass("sidelinkactive");
    </script>
    <script>
        var xValues = [50,60,70,80,90,100,110,120,130,140,150];
var yValues = [7,8,8,9,9,9,10,11,14,14,15];
yValues = <?php echo json_encode($days_amount, 15, 512) ?>;
xValues = <?php echo json_encode($days, 15, 512) ?>;
new Chart("myChart", {
  type: "line",
  data: {
    labels: xValues,
    datasets: [{
        label: 'Amount AUD ',
      borderColor: "rgba(0,0,255,0.1)",
      data: yValues
    }]
  }
});


$('#datatable').dataTable( {
  "pageLength": 50
} );
    </script>
    
    
     <script>
  $(document).ready(function() {
    // Assuming you have the value in the 'scrollToOrder' variable
    var scrollToOrder = <?php echo json_encode($inputs, 15, 512) ?>; // Replace 'true' with your actual variable containing the value

    // Check if the 'scrollToOrder' variable has a value
    if (scrollToOrder!="") {
      // Scroll to the div with ID 'order'
      $('html, body').animate({
        scrollTop: $('#order').offset().top // Scroll to the top position of the 'order' div
      }, 1000); // Adjust the duration as per your preference (1000ms = 1 second)
    }
  });
</script>
    
   
    
 
    
    
    
<?php $__env->stopSection(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/painvdmk/public_html/resources/views/admin/orders/dashboard.blade.php ENDPATH**/ ?>