@extends('user.usermaster')

@section('title', ' Home')
meta_keywordss
@section('stylesheet')
    <style>
        .colorpick:hover {
            cursor: pointer;
        }

    </style>
@endsection

@section('breadcrumb')
    <a href="" class="size-sm text-muted">View Product 1</a>
@endsection
@section('content')




    <div class="container-fluid">
        <br>
        <div class="row" >
            <div class="col-md-12">
                <h4>View Product</h4>
                @if (session('cart_msg'))
                    <br>
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <strong>Message</strong> {{ session('cart_msg') }}
                          <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                @endif
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-6 p-3">
                <div class="img-div border ">
                    <div id="carouselExampleControls" class="carousel slide" class="bg-dark" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            <div class="carousel-item active">

                                <center><img src="{{ asset($product->photo) }}" class="img img-fluid" style="height: 300px;width:310" alt="..."></center>
                            </div>
                            @foreach ($product->getimages as $image)
                                <div class="carousel-item ">

                                <center> <img src="{{ asset($image->images) }}" class="img img-fluid" style="height: 300px;width:310" alt="..."></center>
                                </div>
                                @endforeach

                        </div>
                        <button class="carousel-control-prev text-dark" type="button" data-bs-target="#carouselExampleControls"
                            data-bs-slide="prev">
                            <i class="fa-solid fa-arrow-left size-vlg"></i>
                        </button>
                        <button class="carousel-control-next  text-dark" type="button" data-bs-target="#carouselExampleControls"
                            data-bs-slide="next">
                            <i class="fa-solid fa-arrow-right size-vlg"></i>
                        </button>
                    </div>

                </div><br>


            </div>
            <div class="col-md-6 p-3">
                <label class="text-muted size-sm">Product Detail</label>
                <form method="post" action="{{ route('add_to_cart') }}">
                    @csrf
                    <input type="hidden" name="pid" value="{{ $product->code }}">
                    <table class="table table-sm table-sm-responsive size-nm form-table2">
                        <tr>
                            <td width="15%">
                                <span class="size-nm text-muted">Product Name</span>
                            </td>
                            <td>
                                <h6> {{ $product->name }} </h6>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <span class="size-nm text-muted">Product Price</span>
                            </td>
                            <td>
                                <p class="size-lg ctext size-lg fw-bold"> {{ $product->final_price }}$ <span
                                        class="ctag size-sm">{{ $product->discount }}% Off</span></p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <span class="size-nm text-muted">Product Category</span>
                            </td>
                            <td>
                                <p class="size-lg"> {{ $product->getCategory->name }} </p>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <span class="size-nm text-muted">Gender</span>
                            </td>
                            <td>
                                <p class="size-lg"> {{ $product->gender }} </p>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <span class="size-nm text-muted">Available Quantity</span>
                            </td>
                            <td>
                                <p class="size-lg"> {{ $product->quantity }} </p>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <span class="size-nm text-muted">Select Color</span>
                            </td>
                            <td class="pt-3">
                                @foreach ($product['getColors'] as $color)
                                    <span data-color="{{ $color->color }}" class=" m-2 colorpick  ps-0 pe-1 py-1"><span
                                            class="px-3 py-1 me-1"
                                            style="background-color:{{ $color['color_code'] }}"></span><span
                                            class="size-vsm"> {{ $color->color }}</span></span>
                                @endforeach
                            </td>
                        </tr>


                    </table>
                    <table>
                        <tr>
                            <td width="20%"><span class="size-nm text-muted ps-2"> Selected Color: </span></td>
                            <td><input type="text" readonly class="ctextfield size-sm"
                                    style="border:none;outline:none;font-weight:bold" name="color" id="color"></td>
                            <td width="10%"></td>
                            <td>
                                <span class="size-nm text-muted">Select Size:</span>
                            </td>

                            <td class="p-1">
                                <select name="size" class=" size-sm ctextfield">
                                    @if (sizeof($product->getSizes) >= 1)
                                        <option value="">Choose Size</option>
                                    @else
                                        <option value="">Non Sized</option>
                                    @endif
                                    @foreach ($product->getSizes as $size)
                                        <option value="{{ $size->size }}">{{ $size->size }}</option>
                                    @endforeach
                                </select>
                            </td>
                        </tr>
                    </table>



                    @if (!isset($check))
                        <table class="table table-sm table-sm-responsive mt-3">
                            <tr>
                                <td width="20%">
                                    <input type="number" name="quantity" min="1" max="{{ $product->quantity }}"
                                        class="form-control ctextfield size-sm" required min="1" placeholder="Quantity"
                                        value="1">
                                </td>
                                <td>
                                    <input type="submit" name="submit" class="btn btn-md cbtn size-sm" value="Add to Cart">
                                </td>
                            </tr>
                        </table>
                    @else
                        <h6 class="ctext">Product Already Added in Your Cart</h6>
                    @endif
                </form>

                <br>
                <hr>

            </div>







        </div>
        <div class="row">
            <div class="col-md-12">
                 <div class="card " >
                    <div class="card-header">
                        <h6 class="">Description</h6>
                    </div>
                    <div class="card-body">
                        <?=  $product['description']  ?>
                    </div>
            </div>
            </div>
        </div>
        <br>
        @include('user.reviews')
        <br>
        <div class="row">
            <div class="col-md-6">

            </div>
        </div>
        <div class="row">
            <div class="col-md-12"><br><br>
                <h5 class="text-center fw-bold p-1 cbg text-light">Related Products</h5>

            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <x-productcards :products=$related_products />

            </div>
        </div>
    </div>


@endsection
@section('specificscripts')
    <script>
        $(".colorpick").click(function() {
            $("#color").val($(this).attr("data-color"));
            $(".colorpick").css({
                "border": "none"
            });
            $(this).css({
                "border": "2px solid black"
            });
        })
    </script>
@endsection
