@extends('user.usermaster2')

@section('title', ' Home')
@section('style')

@endsection


@section('body')

    <main class="bg_gray">
        <div class="container margin_30">
            <div class="page_header">
                <div class="breadcrumbs">
                    <ul>
                        <li><a href="#">Home</a></li>
                        <li><a href="#">Category</a></li>
                        <li>Page active</li>
                    </ul>
                </div>
                <h1>Cart page</h1>
            </div>
            <!-- /page_header -->
            <table class="table table-striped table-borderless cart-list">
                <thead>
                    <tr>
                        <th>
                            Product
                        </th>

                        <th>
                            Price
                        </th>
                        <th>
                            Quantity
                        </th>
                        <th>
                            Subtotal
                        </th>
                        <th>

                        </th>
                    </tr>
                </thead>
                <tbody>
                    @php $price=0; @endphp
                    @foreach ($carts as $cart)
                        @php
                            $price = $price + $cart->total_amount;
                        @endphp
                        <tr>
                            <td>
                                <div class="thumb_cart">
                                    <img src="{{ asset($cart->getProduct->photo) }}"
                                        data-src="{{ asset($cart->getProduct->photo) }}" class="lazy"
                                        alt="Image">
                                </div>
                                <span class="item_cart">{{ $cart->getProduct->name }}</span>
                            </td>

                            <td>
                                <strong>${{ $cart->price }}</strong>
                            </td>
                            <td>
                                <div class="numbers-row">
                                    <form method="post" action="{{ route('update_cart_quantity') }}"
                                        class="form-inline" id="cart-form">
                                        @csrf
                                        <input type="hidden" name="pid" value="{{ $cart->product_id }}">
                                        <input type="text" id="quantity_1" class="qty2" name="quantity"
                                            max="{{ $cart->getProduct->quantity }}" required min="1"
                                            value="{{ $cart->quantity }}">

                                        <div class="inc button_inc">+</div>
                                        <div class="dec button_inc">-</div>
                                    </form>
                                </div>

                            </td>
                            <td>
                                <strong>${{ $cart->total_amount }}</strong>
                            </td>
                            <td class="options">
                                <form method="post" action="{{ route('delete_cart') }}" class="mt-2">
                                    @csrf
                                    <input type="hidden" name="pid" value="{{ $cart->product_id }}">
                                    <button type="submit" class="text-danger fw-bolder bg-grey" style="border: none"><i
                                            class="ti-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                    @endforeach


                </tbody>
            </table>



        </div>
        <!-- /container -->

        <div class="box_cart">
            <div class="container">
                <div class="row justify-content-end">
                    <div class="col-xl-4 col-lg-4 col-md-6">
                        <ul>

                            <li>
                                <span>Total</span> ${{ $price }}
                            </li>
                        </ul>
                        <a href="{{ route('checkout') }}" class="btn_1 full-width cart">Proceed to Checkout</a>
                    </div>
                </div>
            </div>
        </div>
        <!-- /box_cart -->

    </main>


@endsection
