@extends('user.usermaster')

@section('title', ' Home')
@section('stylesheet')
    <style>
        .colorpick:hover {
            cursor: pointer;
        }

    </style>
@endsection

@section('breadcrumb')
    <a href="" class="size-sm text-muted">User Cart</a>
@endsection
@section('content')




<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 offset-md-1">
            <div class="blockdiv mt-3">
            <h6 class="mb-3">Your Cart Items
            @if(session("cart_update_status"))
            <div class="alert alert-info alert-dismissible fade show" role="alert">
                <strong>Message</strong> {{ session("cart_update_status") }}
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
              </div>
            @endif
            @if(sizeof($carts)>=1)<a class="btn btn-sm cbtn float-end p-1 px-2  size-vsm" href="{{ route('checkout') }}">Check Out <i class="fas fa-arrow-right"></i></a>@endif</h6>
            <table class="table table-sm table-sm-responsive ">
                @foreach ( $carts as $cart )






                <tr>
                    <td width="10%">
                        <img src="{{ asset($cart->getProduct->photo) }}" class="img img-fluid logo-lg">
                    </td>
                    <td width="40%">
                        <label class="size-sm">Name:</label>
                        <h6 class="size-nm">{{ $cart->getProduct->name }} | {{ $cart->size }} | {{ $cart->color }}</h6>
                    </td>
                    <td width="10%">
                        <label class="size-sm">Discount:</label>
                        <h6 class="size-nm">{{ $cart->discount }}%</h6>
                    </td>

                    <td width="10%">
                        <label class="size-sm">Price:</label>
                        <h6 class="size-nm">{{ $cart->price }}</h6>
                    </td>
                    <td width="10%">
                        <label class="size-sm">Total:</label>
                        <h6 class="size-nm">{{ $cart->total_amount }}</h6>
                    </td>
                    <td>
                        <form method="post" action="{{ route('update_cart_quantity') }}" class="form-inline">
                            @csrf

                            <label class="size-sm">Quantity:</label><br> <input type="number" min="1" max="{{ $cart->getProduct->quantity }}" value="{{ $cart->quantity }}" name="quantity" required min="1" class="p-1 ctextfield size-sm">
                            <input type="hidden" name="pid" value="{{ $cart->product_id }}">
                            <button type="submit" class="btn btn-sm size-vsm ctext mb-1 float-end "><i class="fas fa-check"></i></button>
                        </form>
                        <form  method="post" action="{{ route('delete_cart') }}" class="mt-2">
                            @csrf
                            <input type="hidden" name="pid" value="{{ $cart->product_id }}">
                            <button type="submit" class="btn btn-sm size-vsm  p-1 px-2 mb-1 text-danger fw-bolder float-end" >X</button>
                        </form>

                    </td>
                </tr>
                @endforeach
            </table>
        </div>
    </div>
    </div>
</div>


@endsection

