@extends('user.usermaster2')

@section('title', 'Orders')
@section('stylesheet')

@endsection

{{-- @section('breadcrumb')
    <a href="" class="size-sm text-muted">Orders</a>
@endsection --}}
@section('body')


<main class="bg_gray">

			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-xl-7 col-lg-9 ">
						<img src="{{asset('static/images/track.jpeg')}}" alt="" class="img-fluid add_bottom_15" width="300" height="200">
						<p>Quick Tracking Order</p>
						<form method="get">
							<div class="search_bar">
								<input type="text" class="form-control" name="order" placeholder="Invoice ID">
								<input type="submit" value="Search" value="Get Detail">
							</div>
						</form>
					</div>
				</div>
				<!-- /row -->
			</div>
			<!-- /container -->

</main>



    <div class="container ">
        <div class="row">
            {{-- <div class="col-md-3 ">
                <form method="get" >

                    <input type="text" class="form-control size-nm ctextfield" name="order" placeholder="Enter Order No to See Detail...." required><br>
                    <input type="submit" class="btn btn-sm cbtn form-control" value="Get Detail">
                </form>
            </div> --}}
            <div class="col-md-12 ">
                @if(session("alert"))
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                <strong> Success! </strong> Your Order has been placed.
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
                @endif
                @if(isset($order))
                <div class="blockdiv p-3 " style="border:1px solid grey">

                    <h5 class="text-center">ORDER DETAIL <hr></h5>
                    <table class="table table-sm table-sm-repsonsive">
                        <tr>
                            <td width="33%">
                                <label class="text-muted size-sm">Order No:</label>
                                <h6 class="size-nm">{{ $order['order_no'] }}</h6>
                            </td>
                            <td width="33%">
                                <label class="text-muted size-sm">Date:</label>
                                <h6 class="size-nm">{{ date('d M Y H:i A',$order->created_at->timestamp) }}</h6>
                            </td>

                            <td>
                                <label class="text-muted size-sm">Status</label>
                                <h6 class="size-nm">{{ $order->status }}</h6>
                            </td>

                        </tr>
                        <tr>
                            <th colspan="3"><br>Customer Information:</th>
                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">First Name:</label>
                                <h6 class="size-nm">{{ $order->name }}</h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Last Name:</label>
                                <h6 class="size-nm">{{ $order->last_name }}</h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Email</label>
                                <h6 class="size-nm">{{ $order->email }}</h6>
                            </td>

                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">Phone</label>
                                <h6 class="size-nm">{{ $order->phone }}</h6>
                            </td>

                            <td>
                                <label class="text-muted size-sm">Country</label>
                                <h6 class="size-nm">{{ $order->country }}</h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">State</label>
                                <h6 class="size-nm">{{ $order->state }}</h6>
                            </td>



                        </tr>
                        <tr>

                            <td>
                                <label class="text-muted size-sm">Street</label>
                                <h6 class="size-nm">{{ $order->street }}</h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Postal Code:</label>
                                <h6 class="size-nm">{{ $order->postal_code }}</h6>
                            </td>

                        </tr>
                        <tr>
                            <th colspan="3"><br>Delivery Details:</th>
                        </tr>
                        <tr>
                            <td>
                                <label class="text-muted size-sm">Tracking Number:</label>
                                <h6 class="size-nm">{{ $order->tracking_number }}</h6>
                            </td>
                            <td>
                                <label class="text-muted size-sm">Delivery Through</label>
                                <h6 class="size-nm">{{ $order->delivery_through }}</h6>
                            </td>


                        </tr>
                        <tr>
                            <th colspan="3"><br>Order Products :</th>
                        </tr>


                    </table>
                    <table class="table table-sm table-sm-repsonsive size-sm">
                        <tr>
                            <th width="70%">
                                Product
                            </th>
                            <th>
                                Pack Size
                            </th>
                            <th>
                                Quantity
                            </th>
                            <th>
                                Price
                            </th>
                        </tr>
                        @foreach($order->getProducts as $product)
                        <tr>
                            <td>
                                <h6 class="size-nm"><img src="{{ asset($product->photo) }}" class="logo-nm" >
                                 {{ $product->name }}  {{ $product->pivot->size }} {{ $product->pivot->color }}  </h6>
                            </td>
                              <td>
                                {{ $product->unit }}
                            </td>
                            <td>
                                {{ $product->pivot->quantity }}
                            </td>

                            <td>{{ $product->pivot->total_amount }}
                            </td>
                        </tr>
                        @endforeach

                        <tr>
                            <th></th>
                            <th >
                               Total:
                            </th>
                            <th>
                                ${{ $order->total_price }} USD
                            </th>
                        </tr>
                    </table><br>
                    <hr>
                    <h6 class="mb-3 text-center ctext"> <img src="{{ asset('static/images/main1.png') }}" style="width:140px;height:80px"></h6>

                </div>
                @else
                {{-- <h5 class="ctext text-center">No Result</h5> --}}
                @endif
            </div>

        </div>
        <div class="row">

        </div>
    </div>
    <br>
    <br>


@endsection

