@extends('user.usermaster2')

@section('title', ' Order Info')
@section('style')
    <style>
        .colorpick:hover {
            cursor: pointer;
        }

    </style>
@endsection


@section('body')




    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6 mx-auto">

                <div id="print_div">
                    <div class="blockdiv " style="border:none">

                        <center>
                            <div id="order_info">

                                <img src="{{asset('static/images/cart.gif')}}" class="img" height="190px" width="210px">


                                    <h5 class="text-primary text-center">Your Order is pending. Pay to proceed!</h5>
                                    <p >Total Amount: $<span id="price" class="">{{ $order['total_price'] }}</span></p>
                                      <span>Payment Status is Pending</span>

                                <h6 class="text-danger">Order# {{ $order['order_no'] }} </h6>

                                <p class="size-nm"><span class="text-muted">Placed at:
                                    </span>{{ date('d M Y H:i A',$order['created_at']->timestamp) }}</p>


                                    <div id="smart-button-container" style="width: 400px">
                                        <div style="text-align: center;">
                                            <div id="paypal-button-container"></div>
                                        </div>
                                    </div>

                                    <div class="m-1  p-3">
                                        @php
                                        $stripe_key = 'pk_live_51OhkoeLx12o6pHE9aIoRdpNpWVy7OwbZXPVdEVY798aMNc3HXww9SUl131EO1YQXptkQgeMQCfLYyrU6zYXsABwX00l0cyFcNU';
                                        @endphp

                                                    <div class="text-center mb-2">
                                                        <h5>Pay Through Your Card</h5>
                                                    </div>
                                                    <div class="card">
                                                        <form action="{{route('orderupdate')}}"  method="post" id="payment-form">
                                                            @csrf
                                                            <div class="form-group">
                                                                <div class="card-header">
                                                                    <label for="card-element">
                                                                     Card information
                                                                    </label>
                                                                </div>
                                                                <div class="card-body">
                                                                    <div id="card-element">
                                                                        <!-- A Stripe Element will be inserted here. -->
                                                                    </div>
                                                                    <!-- Used to display form errors. -->
                                                                    <div class="p-2 text-danger" id="card-errors" role="alert"></div>
                                                                    <input type="hidden" name="plan" value="" />
                                                                    <input type="hidden" class="form-control" name="oid" value="{{{ $order['id'] }}}" >
                                                                    <input type="hidden" class="form-control" name="status" value="completed">
                                                                    <input type="hidden"  class="form-control" name="tid" id="cid">
                                                                </div>

                                                            </div>
                                                            <div class="card-footer">
                                                              <button
                                                              id="card-button"
                                                              class="btn btn-dark"
                                                              type="submit"
                                                              data-secret="{{ $intent }}"
                                                              > Pay Secure Payments  </button>
                                                          </div>
                                                      </form>
                                                  </div>


                                    </div>
                                    <form method="post" action="{{route('orderupdate')}}" id="frm">
                                        @csrf
                                        <input type="hidden" class="form-control" name="oid" value="{{{ $order['id'] }}}" >
                                        <input type="hidden" class="form-control" name="status" value="completed">
                                        <input type="hidden"  class="form-control" name="tid" id="tid">

                                    </form>
                            </div>

                        </center>
                    </div>

                    <br>
                </div>

            </div>
        </div>
    </div>


@endsection

@section('scripts')
<script src="https://js.stripe.com/v3/"></script>
<script
src="https://www.paypal.com/sdk/js?client-id=AXdXVcqiuw1mXlIe23i1ttQSuUU0yeJCi9MkC3sQQPPJzsJXYfak9X3Fp_BoHvzHtb0gi4xkCpRDkMfs&currency=USD";
data-sdk-integration-source="button-factory"></script>
{{-- <script
src="https://www.paypal.com/sdk/js?client-id=AeIDYc4_OnnKIm2zOcXSJp7zDn021Aw30NkRxdwNMfVuWUOWaWi7ZZ_GtKndkF8d7Pvr85SWtQJlp1IK&enable-funding=venmo&currency=AUD";
data-sdk-integration-source="button-factory"></script> --}}
<script>
      document.addEventListener('contextmenu', function (e) {
            e.preventDefault();
        });
</script>
   <script>
        var price=$('#price').html();

        function initPayPalButton() {
            paypal.Buttons({
                style: {
                    shape: 'rect',
                    color: 'gold',
                    layout: 'vertical',
                    label: 'paypal',
                },
                createOrder: function(data, actions) {
                    return actions.order.create({

                        purchase_units: [{
                            "amount": {
                                "currency_code": "USD",
                                "value": price
                            }
                        }]
                    });
                },

                onApprove: function(data, actions) {

                    return actions.order.capture().then(function(orderData) {
                        // Full available details
                        console.log('Capture result', orderData, JSON.stringify(orderData, null,
                        2));
                        if(orderData['purchase_units'][0]['payments']['captures'][0]['id'])
                        {
                            // $('#tid').val(orderData['purchase_units'][0]['payments']['captures'][0]['id']);
                            // $('#status').val(orderData['purchase_units'][0]['payments']['captures'][0]['status']);
                        }

                        // Show a success message within this page, e.g.
                        const element = document.getElementById('paypal-button-container');
                        element.innerHTML = '';
                        element.innerHTML = '<h3>Thank you for your payment!</h3>'; // Or go to another
                        URL: actions.redirect('thank_you.html');
                        $('#tid').val("paypal");
                        $('#frm').submit();
                    });
                },
                onError: function(err) {
                    console.log(err);
                }
            }).render('#paypal-button-container');
        }
        initPayPalButton();
    </script>
    <script>
        // Custom styling can be passed to options when creating an Element.
        // (Note that this demo uses a wider set of styles than the guide below.)

        var style = {
            base: {
                color: '#32325d',
                lineHeight: '18px',
                fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                    color: '#aab7c4'
                }
            },
            invalid: {
                color: '#fa755a',
                iconColor: '#fa755a'
            }
        };

        const stripe = Stripe('{{ $stripe_key }}', { locale: 'en' }); // Create a Stripe client.
        const elements = stripe.elements(); // Create an instance of Elements.
        const cardElement = elements.create('card', { style: style }); // Create an instance of the card Element.
        const cardButton = document.getElementById('card-button');
        const clientSecret = cardButton.dataset.secret;

        cardElement.mount('#card-element'); // Add an instance of the card Element into the `card-element` <div>.

        // Handle real-time validation errors from the card Element.
        cardElement.addEventListener('change', function(event) {
            var displayError = document.getElementById('card-errors');
            if (event.error) {
                displayError.textContent = event.error.message;
            } else {
                displayError.textContent = '';
            }
        });

        // Handle form submission.
        var form = document.getElementById('payment-form');

        form.addEventListener('submit', function(event) {
            event.preventDefault();

            stripe.handleCardPayment(clientSecret, cardElement, {
                payment_method_data: {
                    //billing_details: { name: cardHolderName.value }
                }
            })
            .then(function(result) {
                console.log(result);
                if (result.error) {
                    // Inform the user if there was an error.
                    var errorElement = document.getElementById('card-errors');
                    errorElement.textContent = result.error.message;
                } else {
                    //console.log(result);
                    $('#cid').val("stripe");
                    form.submit();
                }
            });
        });
    </script>
@endsection
