<style type="text/css">
    @import url('https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700&display=swap');

    * {
        margin: 0;
        padding: 0;
        outline: none;
        box-sizing: border-box;



    }


    nav {
        background: var(--customcolor);
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        justify-content: space-between;
        height: 70px;
        padding: 0 100px;
    }

    nav .logo {
        color: #fff;
        font-size: 25px;
        font-weight: 600;
        letter-spacing: -1px;
    }

    nav .nav-items {
        display: flex;
        flex: 1;
        padding: 0 0 0 40px;
    }

    nav .nav-items li {
        list-style: none;
        padding: 0 15px;
    }

    nav .nav-items li a {
        color: white;
        font-size: 15px;
        font-weight: 500;
        text-decoration: none;
    }

    nav .nav-items li a:hover {
        color: var(--customcolor2);
    }

    nav form {
        display: flex;
        height: 40px;
        padding: 2px;
        background: white;
        min-width: 18% !important;
        border-radius: 2px;
        border: 1px solid rgba(155, 155, 155, 0.2);
    }

    nav form .search-data {
        width: 100%;
        height: 100%;
        padding: 0 10px;
        color: black;
        font-size: 14px;
        border: none;
        font-weight: 500;
        background: none;
    }

    nav form button {
        padding: 0 15px;
        color: black;
        font-size: 14px;
        background: var(--customcolor2);
        border: none;
        border-radius: 2px;
        cursor: pointer;
    }

    nav form button:hover {
        background: #e63600;
    }

    nav .menu-icon,
    nav .cancel-icon,
    nav .search-icon {
        width: 40px;
        text-align: center;
        margin: 0 50px;
        font-size: 18px;
        color: #fff;
        cursor: pointer;
        display: none;
    }

    nav .menu-icon span,
    nav .cancel-icon,
    nav .search-icon {
        display: none;
    }

    @media (max-width: 1245px) {
        nav {
            padding: 0 50px;
        }
    }

    @media (max-width: 1140px) {
        nav {
            padding: 0px;
        }

        nav .logo {
            flex: 2;
            text-align: center;
        }

        nav .nav-items {
            position: fixed;
            z-index: 99;
            top: 70px;
            width: 100%;
            left: -100%;
            height: 100%;
            padding: 10px 50px 0 50px;
            text-align: center;
            background: #14181f;
            display: inline-block;
            transition: left 0.3s ease;
        }

        nav .nav-items.active {
            left: 0px;
        }

        nav .nav-items li {
            line-height: 40px;
            margin: 30px 0;
        }

        nav .nav-items li a {
            font-size: 20px;
        }

        nav form {
            position: absolute;
            top: 80px;
            right: 20px;
            opacity: 0;
            pointer-events: none;
            transition: top 0.3s ease, opacity 0.1s ease;
        }

        nav form.active {
            top: 95px;
            opacity: 1;
            pointer-events: auto;
        }

        nav form:before {
            position: absolute;
            content: "";
            top: -13px;
            right: 0px;
            width: 0;
            height: 0;
            z-index: -1;
            border: 10px solid transparent;
            border-bottom-color: #1e232b;
            margin: -20px 0 0;
        }

        nav form:after {
            position: absolute;
            content: '';
            height: 60px;
            padding: 2px;
            background: #1e232b;
            border-radius: 2px;
            min-width: calc(100% + 20px);
            z-index: -2;
            left: 50%;
            top: 50%;
            transform: translate(-50%, -50%);
        }

        nav .menu-icon {
            display: block;
        }

        nav .search-icon,
        nav .menu-icon span {
            display: block;
        }

        nav .menu-icon span.hide,
        nav .search-icon.hide {
            display: none;
        }

        nav .cancel-icon.show {
            display: block;
        }
    }



    nav .logo.space {
        color: red;
        padding: 0 5px 0 0;
    }

    @media (max-width: 980px) {

        nav .menu-icon,
        nav .cancel-icon,
        nav .search-icon {
            margin: 0 20px;
        }

        nav form {
            right: 30px;
        }
    }

    @media (max-width: 350px) {

        nav .menu-icon,
        nav .cancel-icon,
        nav .search-icon {
            margin: 0 10px;
            font-size: 14px;
        }
    }



</style>
<marquee class="p-1 fw-bold"> <i class="fa-solid fa-dolly"></i> FAST & FREE DELIVERY AUSTRALIA WIDE </marquee>
<nav>
    <div class="menu-icon">
       <span class="fas fa-bars"></span>
    </div>
    <div class="logo">
         Pain Free Australia <a href="{{ route('user_cart') }}" class="text-light size-lg mb-1 btn btn-sm ms-2"><i class="fab fa-opencart"></i>
          @if(session("cart_quantity"))  <sup class=" mb-2 size-vsm bg-light text-dark py-1 px-2 fw-bolder" style="border-radius: 50%">{{ session("cart_quantity") }}</sup>@endif
        </a>
    </div>
    <div class="nav-items">
       <li><a href="/">Home</a></li>
       <li><a href="{{ route('all_products') }}">Product</a></li>
       <li><a href="{{ route("user_orders") }}">Orders</a></li>



    </div>
    <div class="search-icon">
       <span class="fas fa-search"></span>
    </div>
    <div class="cancel-icon">
       <span class="fas fa-times"></span>
    </div>
    <form id="search_form" style="z-index:5">

       <input type="search" id="search_field" class="search-data" style="color:var(--customcolor)" placeholder="Search" required>
       <button type="submit" class="fas fa-search"></button>
    </form>
 </nav>







<script type="text/javascript">
    $("#search_form").submit(function(event) {

        event.preventDefault();
        var val = $("#search_field").val();
        var curent_url = new URL(window.location.href);
        var search_params = curent_url.searchParams;
        search_params.set('search', val);

        curent_url.search = search_params.toString();

        var new_url = curent_url.toString();
        //console.log(new_url);
        new_url = new_url.split("?");


        window.location = "/products?" + new_url[1];

    });


    const menuBtn = document.querySelector(".menu-icon span");
         const searchBtn = document.querySelector(".search-icon");
         const cancelBtn = document.querySelector(".cancel-icon");
         const items = document.querySelector(".nav-items");
         const form = document.querySelector("form");
         menuBtn.onclick = ()=>{
           items.classList.add("active");
           menuBtn.classList.add("hide");
           searchBtn.classList.add("hide");
           cancelBtn.classList.add("show");
         }
         cancelBtn.onclick = ()=>{
           items.classList.remove("active");
           menuBtn.classList.remove("hide");
           searchBtn.classList.remove("hide");
           cancelBtn.classList.remove("show");
           form.classList.remove("active");
           cancelBtn.style.color = "#ff3d00";
         }
         searchBtn.onclick = ()=>{
           form.classList.add("active");
           searchBtn.classList.add("hide");
           cancelBtn.classList.add("show");
         }
</script>
