@extends('admin.adminmaster')
@section('title')
    Admin-Categories
@endsection

@section('content')
@section('heading')
    Categories
@endsection

<div class="row">
    <div class="container">
        <h2>CJ Dropshipping Products</h2>
        <form method="GET">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <input name="name" placeholder="Search By Name" class="form-control" value="{{ ($inputs['name'] ?? '') }}">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <select class="form-control" name="category">
                            <option value="">Search By Category</option>
                            <option value="8E00C4BE-1E35-43E7-A891-6CAE58BB48CF"
                                {{ isset($inputs['category']) && $inputs['category'] == '8E00C4BE-1E35-43E7-A891-6CAE58BB48CF' ? 'selected' : '' }}>
                                Massage & Relaxation
                            </option>
                            <option value="E0238E88-0C63-427F-812E-BA1FCE4C67B4"
                                {{ isset($inputs['category']) && $inputs['category'] == 'E0238E88-0C63-427F-812E-BA1FCE4C67B4' ? 'selected' : '' }}>
                                Body Care
                            </option>
                            <option value="2409190611101616600"
                                {{ isset($inputs['category']) && $inputs['category'] == '2409190611101616600' ? 'selected' : '' }}>
                                Health Care Products
                            </option>
                            <option value="2C7D4A0B-1AB2-41EC-8F9E-13DC31B1C902"
                            {{ isset($inputs['category']) && $inputs['category'] == '2C7D4A0B-1AB2-41EC-8F9E-13DC31B1C902' ? 'selected' : '' }}>
                            Health Beauty & Hair
                        </option>
                        </select>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="">
                        <button type="submit" class="btn btn-sm btn-primary">Search</button>
                    </div>
                </div>
            </div>



        </form>
        <div class="row">
            @foreach ($products as $product)
                <div class="col-md-3">
                    <div class="card mb-4">
                        <img src="{{ $product['productImage'] ?? 'default.jpg' }}" class="card-img-top"
                            alt="Product Image">
                        <div class="card-body">
                            <h5 class="card-title">{{ $product['productName'] ?? '' }}</h5>
                            <h6 class="text-success">{{ $product['categoryName'] ?? 'Uncategorized' }}</h6>
                            <p class="card-text"><strong>Price:</strong> ${{ $product['sellPrice'] ?? 'N/A' }}</p>
                                                    @php
                                $originalPrice = isset($product['sellPrice']) ? preg_replace('/[^0-9.]/', '', $product['sellPrice']) : 0;
                                $originalPrice = is_numeric($originalPrice) ? (float) $originalPrice : 0; // Ensure it's a float
                                $increase = $originalPrice * 0.4; // 40% of the original price
                                $finalPrice = $originalPrice + $increase;
                            @endphp
                            <p class="card-text"><strong>Final Price (with 40% added):</strong> ${{ number_format($finalPrice, 2) }}</p>


                            <!-- Variants Section -->
                            {{-- @if (!empty($product['variants']))
                                <h6>Variants:</h6>
                                <div class="d-flex flex-wrap">
                                    @foreach ($product['variants'] as $variant)
                                    <img src="{{ $variant['variantImage'] ?? 'default.jpg' }}" class="card-img-top"
                                    alt="Product Image">
                                        <span class="badge bg-secondary m-1">
                                            {{ $variant['variantNameEn'] ?? 'No Name' }} -
                                            ${{ $variant['variantSellPrice'] ?? 'N/A' }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif --}}



                            <!-- Import Button -->
                            <button class="btn btn-primary import-btn" data-id="{{ $product['productId'] }}"
                                data-name="{{ $product['productName'] }}" data-price="{{ $product['sellPrice'] }}"
                                data-image="{{ $product['productImage'] }}"
                                data-category="{{ $product['categoryName'] }}"
                                data-description="{{ $product['description'] }}">
                                Import
                            </button>
                        </div>
                    </div>
                </div>
            @endforeach


        </div>
        <div class="row">
            <div class="col-md-12 text-center">
                <div class="d-flex justify-content-center mt-4">
                    @php
                        $prevPage = $page > 1 ? $page - 1 : 1;
                        $nextPage = $page + 1;
                    @endphp

                    <a href="{{ route('cj.products', ['name'=>request('name'),'category' => request('category'), 'page' => $prevPage]) }}"
                        class="btn btn-secondary {{ $page == 1 ? 'disabled' : '' }}">
                        ⬅️ Previous
                    </a>

                    <a href="{{ route('cj.products', ['name'=>request('name'),'category' => request('category'), 'page' => $nextPage]) }}"
                        class="btn btn-primary ms-2">
                        Next ➡️
                    </a>
                </div>
            </div>
        </div>
    </div>

</div>
@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $(".import-btn").click(function() {
                let button = $(this);
                let productId = button.data("id");
                let productName = button.data("name");
                let productPrice = button.data("price");
                let productImage = button.data("image");
                let description = button.data("description");

                // Get the selected category ID from the dropdown
                //let categoryName = $("select[name='category'] option:selected").text();
                let categoryName = button.data("category");
                console.log(categoryName);
                $.ajax({
                    url: "{{ route('cj.import') }}",
                    type: "POST",
                    data: {
                        _token: "{{ csrf_token() }}",
                        productId: productId,
                        productName: productName,
                        productPrice: productPrice,
                        productImage: productImage,
                        categoryName: categoryName, // Pass category ID
                        description: description
                    },
                    beforeSend: function() {
                        button.text("Importing...").prop("disabled", true);
                    },
                    success: function(response) {
                        if (response.success) {
                            button.text("Imported ✔").removeClass("btn-primary").addClass(
                                "btn-success");
                        } else {
                            alert(response.message);
                            button.text("Import").prop("disabled", false);
                        }
                    },
                    error: function(xhr) {
                        alert("Something went wrong! Try again.");
                        button.text("Import").prop("disabled", false);
                    }
                });
            });

        });
    </script>
@endsection
@endsection
