@extends("admin.adminmaster")
@section("title") Dashboard @endsection

@section("content")
@section("heading") Dashboard @endsection

<div class="card">
	<div class="card-header">
		Apply Filters
	</div>
	<div class="card-body">
		<div class="container-fluid">
			<form class="row mb-4" method="GET" >
				<div class="col-md-3">
					<label>Select Date:</label>
					<input type="date" name="date" value="{{ ($filters['date'] ?? '' ) }}" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Month:</label>
					<input type="number" min="1" max="12" name="month" value="{{ ($filters['month'] ?? '' ) }}" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Year:</label>
					<input type="number" min="2021" max="2099" name="year" value="{{ ($filters['year'] ?? '' ) }}" class="form-control">
				</div>
				<div class="col-md-3">
					<label>Enter Email of customer:</label>
					<input type="email" name="email" value="{{ ($filters['email'] ?? '' ) }}" class="form-control">
				</div>
				<div class="col-md-12 text-right mt-1">
					<button class="btn btn-sm btn-primary">Apply Filter</button>
					<!--<button class="btn btn-sm btn-md btn-secondary">Show Filter</button>-->

				</div>
			</form>
			
			@if($amount!="")
			    <label class="bg-primary size-nm badge mb-2 text-light py-2 px-2">Total Amount: ({{$amount}})</label>
			    <label class="bg-secondary size-nm badge mb-2  text-light  py-2 px-2">Total Orders: ({{sizeof($orders)}})</label>

			@endif
				    <table id="datatable" class="maintbl table table-sm table-sm-responsive size-nm table-hover ">
                        <thead>
                            <tr>
                                <th>ID
                                </th>
                                <th>Price
                                </th>
                                <th>Name </th>
                                <th>Phone</th>
                                <th>Placed At
                                </th>
                                <th>Status
                                </th>
                                <th width="10%">Action
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($orders as $order)
                                <tr>
                                    <td>{{ $order['order_no'] }}
                                    </td>
                                    <td>{{ $order['total_price'] }} AUD
                                    </td>
                                    <td>{{ $order['name'] }} <span class='text-muted'>({{$order['email']}}) </span>
                                    </td>
                                    <td>{{ $order['phone'] }}
                                    </td>

                                    <td>{{ $order['created_at'] }}
                                    </td>
                                    <td>{{ $order['status'] }}
                                    </td>

                                    <td>
                                        <a href={{ route('admin_order_detail', $order->order_no) }} class="editactionbtn"><i
                                                class="fad fa-edit"></i></a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

		</div>
	</div>
</div>
	







@endsection


@section('script')
<script>
    $('#datatable').dataTable( {
  "pageLength": 50
} );
</script>


@endsection
