@extends('admin.adminmaster')
@section('title')
    Admin-Products
@endsection

@section('content')
@section('heading')
    Products
@endsection

<div class="row">
    <div class="col-md-12">
        @if (session('product_msg'))
            @if (session('product_msg') == 'true')
                <br>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Success! </strong> Reviews has been Deleted Successfully
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @else
                <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                    <strong> Failed! </strong> Some Issue Occured. Try Again
                     <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
        @endif
        {{-- <a href="{{ route('addproduct') }}" class="btn btn-sm cbtn float-end size-vsm"><i class="far fa-plus"></i> Add New Product</a><br><br><br> --}}

        {{-- <div class="btn-group text-right d-block" role="group" aria-label="Basic example">

            <a href="{{ route('seller_discount_products') }}" class="btn btn-sm btn-warning  float-end"><i
                    class="far fa-tags"></i> Discount Products</a>
            <a href="{{ route('addproduct') }}" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i>
                Add
                New Product</a>
        </div> --}}

        <div class="card">
            <div class="card-header"> Reviews</div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>
                            <th>Review
                            </th>

                            <th>Rating
                            </th>
                             <th>Date
                            </th>
                            <th >Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($reviews as $review)
                            <tr>
                                <td>{{ $review['id'] }}
                                </td>
                                <td>{{ $review['name'] }}
                                </td>
                                <td>{{ $review['review'] }}
                                </td>

                                <td>{{ $review['stars'] }} Stars
                                </td>
                                  <td>{{ \Carbon\Carbon::parse($review->created_at)->diffForHumans() }}
                                </td>


                                <td>
                                    <a href="{{ route('delete_review', $review['id']) }}" class=""><i
                                            class="fad fa-trash"></i></a>


                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>


    </div>
</div>
@section('script')
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
@endsection




@endsection
