@extends('admin.adminmaster')
@section('title')
    Admin-Products
@endsection

@section('content')
@section('heading')
    Products
@endsection

<div class="row">
    <div class="col-md-12">
        @if (session('product_msg'))
            @if (session('product_msg') == 'true')
                <br>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Success! </strong> Producthas been Deleted Successfully
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @else
                <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                    <strong> Failed! </strong> Some Issue Occured. Try Again
                      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
        @endif
        {{-- <a href="{{ route('addproduct') }}" class="btn btn-sm cbtn float-end size-vsm"><i class="far fa-plus"></i> Add New Product</a><br><br><br> --}}

        <div class="btn-group text-right d-block" role="group" aria-label="Basic example">

            <a href="{{ route('seller_discount_products') }}" class="btn btn-sm btn-warning  float-end"><i
                    class="far fa-tags"></i> Discount Products</a>
            <a href="{{ route('addproduct') }}" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i>
                Add
                New Product</a>
        </div>

        <div class="card">
            <div class="card-header">View Products</div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>
                            <th>Code
                            </th>

                            <th>Discount
                            </th>

                            <th>Price
                            </th>
                            <th>Image
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $product)
                            <tr>
                                <td>{{ $product['id'] }}
                                </td>
                                <td>{{ $product['name'] }}
                                </td>
                                <td>{{ $product['code'] }}
                                </td>

                                <td>@if($product['discount']>0){{ $product['discount'] }}%@else N/A @endif
                                </td>
                                <td>${{ $product['final_price'] }}
                                </td>

                                <td>

                                    @php
                                        $rating = 0;
                                        $reviewCount = count($product->getReviews);

                                        foreach ($product->getReviews as $review) {
                                            $rating += $review->stars; // Assuming `star` is the attribute that stores the rating (e.g., 3, 4, or 5).
                                        }
                                        if ($rating > 0) {
                                            $rating = $rating / sizeof($product->getReviews);
                                        }

                                    @endphp
                                    {{round( $rating,1) }} stars

                                </td>

                                <td><img src="{{ asset($product['photo']) }}" class="img img-fluid logo-nm">
                                </td>
                                <td>

                                    <a href="{{ route('editproduct', $product['id']) }}" class=""><i
                                            class="fad fa-edit"></i></a> |
                                            <a href="{{ route('reviews', $product['id']) }}" class=""><i
                                                class="far fa-comment"></i></a> |
                                    <a href="{{ route('deleteproduct', $product['id']) }}" class=""><i
                                            class="fad fa-trash"></i></a> |
                                    <a href="{{ route('add_product_images', $product['id']) }}"
                                        class="deleteactionbtn"><i class="fa fa-eye"></i></a>

                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>


    </div>
</div>
@section('script')
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
@endsection




@endsection
