@extends('admin.adminmaster')
@section('title')
    Admin- Edit Product
@endsection
@section('heading')
    Edit Product
@endsection
@section('content')


<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h6> Edit Product </h6>
            </div>
            <div class="card-body">
                <a href="{{ route('product_description') }}?product={{ $product['code'] }}"
                    class="btn btn-sm btn-info float-right m-3">Edit More Info</a>
                <br>
                <h6> Fill the Required Fields</h6>
                @if (session('product_msg'))
                    @if (session('product_msg') == 'true')

                        <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                            <strong> Success! </strong> Product has been Edited Successfully
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                    @else
                        <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                            <strong> Failed! </strong> Some Issue Occured. Try Again
                            <button type="button" class="close" data-dismiss="alert"
                                aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        </div>
                    @endif
                @endif


                <form method="post" class="size-sm" action="{{ route('updateproduct') }}"
                    enctype="multipart/form-data">
                    @csrf
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Name*: </h6>
                            </td>
                            <td>
                                <input type="text" id="name" name="name" min required
                                    value="{{ $product['name'] }}" class="form-control ctextfield size-nm"
                                    placeholder="Enter Product Title...">
                                <span class="text-danger size-nm"> @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Category* </h6>
                            </td>
                            <td>
                                <select name="category" id="category" class="form-control ctextfield size-sm" required>
                                    <option value="">Choose Category</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category['id'] }}"
                                            {{ $product['category_id'] == $category['id'] ? 'selected' : '' }}>
                                            {{ $category['name'] }} ({{ $category['code'] }})</option>
                                    @endforeach

                                </select>
                                <span class="text-danger size-nm"> @error('category')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Price*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="price" name="price" value="{{ $product['final_price'] }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product price...">
                                <span class="text-danger size-nm"> @error('price')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                         <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Priority*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="priority" name="priority" value="{{ $product['priority'] }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Priority...">
                                <span class="text-danger size-nm"> @error('priority')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Quantity*: </h6>
                            </td>
                            <td>
                                <input type="number"  id="quantity" name="quantity"
                                    value="{{ $product['quantity'] }}" class="form-control ctextfield size-nm"
                                    placeholder="Enter Product quantity...">
                                <span class="text-danger size-nm"> @error('quantity')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product For </h6>
                            </td>
                            <td>
                                <select name="gender" id="gender" class="form-control ctextfield size-sm" >
                                    <option value="">Choose Gender</option>
                                    <option value="male" {{ $product['gender'] == 'male' ? 'selected' : '' }}>Male
                                    </option>
                                    <option value="female" {{ $product['gender'] == 'female' ? 'selected' : '' }}>
                                        Female
                                    </option>
                                    <option value="uni_sex" {{ $product['gender'] == 'uni_sex' ? 'selected' : '' }}>
                                        UniSex
                                    </option>
                                </select>
                                <span class="text-danger size-nm"> @error('gender')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>




                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Photo* </h6>
                            </td>
                            <td>
                                <input type="file" id="photo" name="photo" class="  size-nm"
                                    value="{{ $product['photo'] }}">
                                <span class="text-danger size-nm"> @error('photo')
                                        {{ $message }}
                                    @enderror
                                </span>
                                <input type="checkbox" name="image_change" value="true">
                                <span class="text-danger size-nm">Change Image</span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Description* </h6>
                            </td>
                            <td>
                                <textarea id="description" name="description">{!! $product['description'] !!}</textarea>
                                <!--<textarea id="description" name="description">hello</textarea>-->

                                <span class="text-danger size-nm"> @error('description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Meta Title*: </h6>
                            </td>
                            <td>
                                <input type="text"  name="meta_name" value="{{ $product['meta_title'] }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter  Product Meta Title...">
                                <span class="text-danger size-nm"> @error('meta_name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Meta Description* </h6>
                            </td>
                            <td>
                                <textarea id="meta_description"   rows="5" style="width: 100%" name="meta_description">{!! $product['meta_description'] !!}</textarea>


                                <span class="text-danger size-nm"> @error('meta_description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <input type="hidden" value="{{ $product['id'] }}" name="id">
                            <td colspan="2" class="text-right">
                                <input type="submit" name="submit" class="btn btn-sm btn-primary cbtn float-end size-nm"
                                    value="SUBMIT">
                            </td>
                        </tr>



                    </table>




                </form>

            </div>
        </div>





    </div>



</div>
@endsection
@section('script')
<script type="text/javascript">
    $("#sideproducts").addClass("sidelinkactive");
    CKEDITOR.replace('description');

</script>
@endsection
