@extends('admin.adminmaster')
@section('title')
    Admin-Product
@endsection

@section('content')
@section('heading')
    Product
@endsection

<div class="row">

    <div class="col-md-12">
        <div class="card">
            @if (session('product_msg'))
            @if (session('product_msg') == 'true')
                <br>
                <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                    <strong> Success! </strong> Product has been Added Successfully
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @else
                <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                    <strong> Failed! </strong> Some Issue Occured. Try Again
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
            @endif
        @endif
            <div class="card-header">
                <h6> Add new Product </h6>
            </div>
            <div class="card-body">
                <h6> Fill the Required Fields</h6>

                <form method="post" class="size-sm" action="{{ route('saveproduct') }}" enctype="multipart/form-data">
                    @csrf
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Name*: </h6>
                            </td>
                            <td>
                                <input type="text" id="name" name="name" value="{{ old('name') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Title...">
                                <span class="text-danger size-nm"> @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Category* </h6>
                            </td>
                            <td>
                                <select name="category" id="category" class="form-control ctextfield size-sm">
                                    <option value="">Choose Category</option>
                                    @foreach ($categories as $category)
                                        <option value="{{ $category['id'] }}">{{ $category['name'] }} ({{ $category['code'] }})
                                        </option>
                                    @endforeach

                                </select>
                                <span class="text-danger size-nm"> @error('category')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                         <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Priority*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="priority" name="priority" value="{{ old('priority') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Priority...">
                                <span class="text-danger size-nm"> @error('priority')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Price*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="price" name="price" value="{{ old('price') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Price...">
                                <span class="text-danger size-nm"> @error('price')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Unit*: </h6>
                            </td>
                            <td>
                                <input type="text" id="unit" name="unit" value="{{ old('unit') }}"
                                    class="form-control ctextfield size-nm" placeholder="i.e Pair...">
                                <span class="text-danger size-nm"> @error('unit')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Product Quantity*: </h6>
                            </td>
                            <td>
                                <input type="number" id="quantity" name="quantity" value="{{ old('quantity') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product quantity...">
                                <span class="text-danger size-nm"> @error('quantity')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product For </h6>
                            </td>
                            <td>
                                <select name="gender" id="gender" class="form-control ctextfield size-sm">
                                    <option value="">Choose Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female"> Female </option>
                                    <option value="uni_sex"> UniSex </option>
                                </select>
                                <span class="text-danger size-nm"> @error('gender')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>




                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Photo* </h6>
                            </td>
                            <td>
                                <input type="file" required id="photo" name="photo" class="  size-nm">
                                <span class="text-danger size-nm"> @error('photo')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Product Description* </h6>
                            </td>
                            <td>
                                <textarea id="description" name="description">{{ old('description') }}</textarea>


                                <span class="text-danger size-nm"> @error('description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Meta Title*: </h6>
                            </td>
                            <td>
                                <input type="text"  name="meta_name" value="{{ old('meta_name') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter  Product Meta Title...">
                                <span class="text-danger size-nm"> @error('meta_name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Meta Description* </h6>
                            </td>
                            <td>

                                <textarea id="meta_description"  rows="5" style="width: 100%"  name="meta_description">{{ old('description') }}</textarea>


                                <span class="text-danger size-nm"> @error('meta_description')
                                        {{ $message }}
                                    @enderror
                                </span>

                            </td>
                        </tr>

                        <td colspan="2" class="text-right">
                            <input type="submit" name="submit" class="btn btn-sm cbtn float-end size-nm" value="SUBMIT">
                        </td>
                        </tr>



                    </table>




                </form>

            </div>
        </div>


    <br>


</div>
</div>
@section('script')
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");

        CKEDITOR.replace('description');

    </script>
@endsection




@endsection
