@extends("admin.adminmaster")
@section('title')
    Admin-Product
@endsection

@section('content')
@section('heading')
    Product
@endsection
<div class="row">
    <div class="col-md-8">
        <div class="blockdiv">
            <h6> Add new Product </h6>
            <div class="linediv">
            </div>
            <br>

            <h6> Fill the Required Fields</h6>
            @if (session('product_msg'))
                @if (session('product_msg') == 'true')
                    <br>
                    <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                        <strong> Success! </strong> Product image has been Added Successfully
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                @else
                    <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                        <strong> Failed! </strong> Some Issue Occured. Try Again
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                @endif
            @endif


                        <table class="table table-sm table-sm-responsive size-sm form-table">
                            <tr>

                               <th>ID</th>
                               <th>Image</th>
                               <th>Prouduct </th>
                               <th>Action</th>
                            </tr>
                            @foreach($images as $image)
                           <tr>
                               <td>{{ $image->id }}</td>
                               <td><img src="{{ asset($image['images']) }}" class="logo-lg rounded-circle"></td>
                               <td>{{ $image->get_product['name'] }}</td>
                               <td><a href="{{route('delete_product_image',$image['id'])}}" class="deleteactionbtn"><i class="fad fa-trash"></i></a></td>
                           </tr>
                           @endforeach




                        </table>

        </div>
    </div>
    <div class="col-md-4">
        <div class="blockdiv">
            <div class="card  p-2">
                <div class="card-head">
                   <h6 class="text-center text-dark"> Add Images</h6>
                </div>
                <div class="card-body">
                    <form method="post" class="size-sm" action="{{ route('saveimage') }}" enctype="multipart/form-data">
                        @csrf
                        <label class=>Upload Product image</label><br>
                        <div class="form-group p-1">
                            <input type="file" class="" accept="image/*" required id="photo" name="photo" class="  size-nm">
                            <span class="text-danger size-nm"> @error('photo')
                                    {{ $message }}
                                @enderror
                            </span>
                        </div>
                        <input type="hidden" name="product_id" value="{{ $product_id }}">
                        <br>
                        <input type="submit" name="submit" class="btn btn-sm cbtn float-end size-nm" value="SUBMIT">
                    </form>
                </div>
            </div>
        </div>


    </div>
</div>






@endsection
