@extends('admin.adminmaster')
@section('title')
    Seller-Products
@endsection

@section('content')
@section('heading')
    Products
@endsection

<div class="row">

    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form method="post" action="{{ route('add_product_to_discount') }}">
                    @csrf
                    <h6>Add Discount</h6>
                    <hr>
                    @if (session('disc_msg'))
                        @if (session('disc_msg') == 'true')
                            <br>
                            <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                                <strong> Success! </strong> Product has been Added Into Discount
                                 <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                        @else
                            <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                                <strong> Failed! </strong> Some Issue Occured. Try Again
                                 <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            </div>
                        @endif
                    @endif
                    <table class=" table table-sm table-sm-responsive size-nm table-hover ">
                        <tr>
                            <td width="50%" class="p-2">
                                <input list="products" autocomplete="off" placeholder="Search Product...." name="product"
                                    value="{{ old('product') }}" id="product" class="form-control ctextfield size-sm">

                                <datalist id="products">
                                    @foreach ($all_products as $product)
                                        <option value="{{ $product['code'] }}" />{{ $product['name'] }}
                                    @endforeach
                                </datalist>
                                <span class="text-danger size-sm">
                                    @error('product')
                                        {{ $message }}
                                    @enderror
                                </span>

                            </td>
                            <td class="p-2">
                                <input type="number" placeholder="Enter Discount" max="80" min="1" name="discount"
                                    value="{{ old('discount') }}" class="form-control ctextfield size-sm">
                                <span class="text-danger size-sm">
                                    @error('discount')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                            <td class="p-2">
                                <input type="submit" name="submit" class="btn btn-sm btn-success" value="Apply">
                            </td>
                        </tr>

                    </table>
                </form>

                <h6>Discount Products</h6>
                <hr>
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                    <thead>
                        <tr>
                            <th>ID
                            </th>
                            <th>Name
                            </th>

                            <th>Discount
                            </th>


                            <th>
                                Image
                            </th>
                            <th width="10%">Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($products as $product)
                            <tr>
                                <td>{{ $product['code'] }}
                                </td>
                                <td>{{ $product['name'] }}
                                </td>


                                <td>{{ $product['discount'] }}%
                                </td>




                                <td><img src="{{ asset($product['photo']) }}" class="img img-fluid logo-nm">
                                </td>
                                <td>
                                    <a href="{{ route('product_description') }}?product={{ $product['code'] }}" class=""><i
                                            class="fad fa-edit"></i></a> |
                                    <a href="{{ route('delete_discount', $product->code) }}" class="deleteactionbtn"
                                        title="Remove from Discount"><i class="fad fa-trash"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    <br>

</div>
</div>





@endsection
