@extends('admin.adminmaster')
@section('title')
    Admin-Posters
@endsection

@section('content')
@section('heading')
    Posters
@endsection

<div class="row">
    <div class="col-md-12">
        <div class="text-right mb-2">
            <a href="{{ route('addposter') }}" class="btn btn-sm btn-primary float-end "><i class="far fa-plus"></i> Add
                New
                Poster</a>
        </div>
        <div class="card">
            <div class="card-header">
                <h6> View Posters </h6>
            </div>
            <div class="card-body">
                <table id="datatable" class="table table-bordered dt-responsive nowrap"
                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                <thead>
                    <tr>
                        <th>ID
                        </th>
                        <th>Title
                        </th>
                        <th>Tag 1
                        </th>
                        <th>Tag 2
                        </th>
                        <th>Status
                        </th>
                        <th>Image
                        </th>
                        <th width="10%">Action
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($posters as $poster)
                        <tr>
                            <td>{{ $poster['id'] }}
                            </td>
                            <td>{{ $poster['title'] }}
                            </td>
                            <td>{{ $poster['tag1'] }}
                            </td>
                            <td>{{ $poster['tag2'] }}
                            </td>
                            <td>{{ $poster['status'] }}
                            </td>
                            <td><img src="{{ asset($poster['photo']) }}" class="img img-fluid logo-nm">
                            </td>
                            <td>

                                <a href="{{ route('deleteposter',$poster['id'])  }}" class="deleteactionbtn"><i
                                        class="fad fa-trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            </div>
        </div>
    </div>


</div>
@section('script')
    <script type="text/javascript">
        $("#sideposter").addClass("sidelinkactive");
    </script>
@endsection




@endsection
