@extends('admin.adminmaster')
@section('title')
    Admin-Posters
@endsection

@section('content')
@section('heading')
    Posters
@endsection

<div class="row">
    <div class="col-md-12">
        @if (session('poster_msg'))
        @if (session('poster_msg') == 'true')
            <br>
            <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                <strong> Success! </strong> Poster has been Added Successfully
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
        @else
            <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                <strong> Failed! </strong> Some Issue Occured. Try Again
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
        @endif
    @endif
        <div class="card">
            <div class="card-header">
                <h6> Add new Poster </h6>
            </div>
            <div class="card-body">
                <h6> Fill the Required Fields</h6>

                <form method="post" class="size-sm" action="{{ route('saveposter') }}" enctype="multipart/form-data">
                    @csrf
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Poster Title*: </h6>
                            </td>
                            <td>
                                <input type="text" id="title" name="title" value="{{ old('title') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Poster Title...">
                                <span class="text-danger size-nm"> @error('title')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Poster Tag 1: </h6>
                            </td>
                            <td>
                                <input type="text" id="tag1" name="tag1" value="{{ old('tag1') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Tag 1...">
                                <span class="text-danger size-nm"> @error('tag1')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Poster Tag 2: </h6>
                            </td>
                            <td>
                                <input type="text" id="tag2" name="tag2" value="{{ old('tag2') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Tag 2...">
                                <span class="text-danger size-nm"> @error('tag2')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Poster Status* </h6>
                            </td>
                            <td>
                                <select name="status"  class="form-control ">
                                    <option value="">Choose Status</option>
                                    <option value="private">Private</option>
                                    <option value="public"> Public </option>
                                </select>
                                <span class="text-danger size-nm"> @error('status')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Poster Photo </h6>
                            </td>
                            <td>
                                <input type="file" id="photo" name="photo" value="{{ old('photo') }}" class="  size-nm">
                                <span class="text-danger size-nm"> @error('photo')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Poster Description </h6>
                            </td>
                            <td>
                                <textarea class=" ctextfield size-nm form-control" name="description" rows="2"
                                    placeholder="Poster Description...">{{ old('description') }}</textarea>
                                <span class="text-danger size-nm"> @error('description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right">
                                <input type="submit" name="submit" class="btn btn-md btn-primary float-end size-nm" value="SUBMIT">
                            </td>
                        </tr>



                    </table>




                </form>
            </div>
        </div>
    </div>






</div>
@section('script')
    <script type="text/javascript">
        $("#sideposter").addClass("sidelinkactive");
    </script>
@endsection




@endsection
