@extends('admin.adminmaster')


@section("style")
<style>
    .logo-nm{
        width:20px;
        height:20px;
    }
</style>
@endsection
@section("content")

<div class="container-fluid">
    <div class="row">
        <div class="col-md-12 mb-3">
            <h1 class="text-center border-top border-bottom py-2">Data Analysis</h1>
        </div>
        
        <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-primary text-light">
                   <h5 class="text-center"><i class="dripicons-briefcase"></i> Current Month Most Selling Products</h5>
                    
                  </li>
                  @foreach($top_month_sellings_products ?? [] as $p)
                   <li class="list-group-item">
                   <img src="{{ asset($p['get_product']['photo'] ?? '') }}" class="logo-nm mr-1"> {{ $p['get_product']['name'] ?? 'N/A' }}
                    <span class="badge badge-primary badge-pill float-right">{{ $p['tq'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
         <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-success text-dark">
                   <h5 class="text-center"><i class="dripicons-briefcase"></i> Overall Most Selling Products</h5>
                    
                  </li>
                  @foreach($top_sellings_products ?? [] as $p)
                   <li class="list-group-item">
                   <img src="{{ asset($p['get_product']['photo'] ?? '') }}" class="logo-nm mr-1"> {{ $p['get_product']['name'] ?? 'N/A' }}
                    <span class="badge badge-success badge-pill text-dark float-right">{{ $p['tq'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
          <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-warning text-dark">
                   <h5 class="text-center"><i class="dripicons-briefcase"></i> Most Selling Categories</h5>
                    
                  </li>
                    @foreach($top_selling_categories ?? [] as $c)
                   <li class="list-group-item">
                   - {{ $c['category_name'] ?? 'N/A' }} -
                    <span class="badge badge-warning badge-pill text-dark float-right">{{ $c['tq'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
        
    </div>
    <div class="row mt-4">
         <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-primary text-light">
                   <h5 class="text-center"><i class="dripicons-location
"></i> Overall Top States With Most Revenue</h5>
                    
                  </li>
                  @foreach($top_generating_states ?? [] as $s)
                   <li class="list-group-item">
                  - {{ $s['state'] ?? 'N/A' }} -
                    <span class="badge badge-primary badge-pill float-right">$ {{ $s['tp'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
         <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-success text-dark">
                   <h5 class="text-center"><i class="dripicons-location
"></i> Current Month Top States With Most Revenue</h5>
                    
                  </li>
                  @foreach($top_month_generating_states ?? [] as $s)
                   <li class="list-group-item">
                  - {{ $s['state'] ?? 'N/A' }} -
                    <span class="badge badge-success text-dark badge-pill float-right">$ {{ $s['tp'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
        
          <div class="col-md-4">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-warning text-dark">
                   <h5 class="text-center"><i class="dripicons-user
"></i> Top Customers with most Revenue</h5>
                    
                  </li>
                    @foreach($top_generating_customers ?? [] as $c)
                   <li class="list-group-item">
                   - {{ $c['name'] ?? 'N/A' }} ( {{ $c['email'] ?? 'N/A' }} ) -
                    <span class="badge badge-warning badge-pill text-dark float-right">$ {{ $c['tp'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
    </div>
    <div class="row mt-4">
         <div class="col-md-6">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-warning text-dark">
                   <h5 class="text-center"><i class="dripicons-inbox
"></i> Products with Quantity less than 70</h5>
                    
                  </li>
                   @foreach($short_products_seventy ?? [] as $p)
                   <li class="list-group-item">
                   <img src="{{ asset($p['photo'] ?? '') }}" class="logo-nm mr-1"> {{ $p['name'] ?? 'N/A' }}
                    <span class="badge badge-warning badge-pill float-right text-dark">{{ $p['quantity'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
         <div class="col-md-6">
            <ul class="list-group">
                  <li class="list-group-item d-flex justify-content-between align-items-center bg-danger text-light">
                   <h5 class="text-center"><i class="dripicons-inbox
"></i> Products with Quantity less than 20</h5>
                    
                  </li>
                   @foreach($short_products_twenty ?? [] as $p)
                   <li class="list-group-item">
                   <img src="{{ asset($p['photo'] ?? '') }}" class="logo-nm mr-1"> {{ $p['name'] ?? 'N/A' }}
                    <span class="badge badge-danger badge-pill float-right text-light">{{ $p['quantity'] ?? 'N/A' }}</span>
                  </li>
                  @endforeach
                 
                 
            </ul>
        </div>
         
    </div>
</div>


@endsection