@extends('admin.adminmaster')
@section('title')
    Admin- Edit Product
@endsection

@section('content')
@section('heading')
    Edit Category
@endsection

<div class="row">
    <div class="col-md-12">
        @if (session('category_msg'))
        @if (session('category_msg') == 'true')
            <br>
            <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                <strong> Success! </strong> Category has been Edited Successfully
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
        @else
            <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                <strong> Failed! </strong> Some Issue Occured. Try Again
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
        @endif
    @endif
        <div class="card">
            <div class="card-header">
                <h6> Edit Category </h6>
            </div>
            <div class="card-body">
                <h6> Fill the Required Fields</h6>

                <form method="post" class="size-sm" action="{{ route('editcategory') }}">
                    @csrf
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Category Name*: </h6>
                            </td>
                            <td>
                                <input type="text" id="name" name="name" value="{{ $category['name'] }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Product Title...">
                                <span class="text-danger size-nm"> @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>

                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Category Priority*: </h6>
                            </td>
                            <td>
                                <input type="number" step="0.01" id="priority" name="priority"
                                    value="{{ $category['priority'] }}" class="form-control ctextfield size-nm"
                                    placeholder="Enter Product Price...">
                                <span class="text-danger size-nm"> @error('price')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>


                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Status </h6>
                            </td>
                            <td>
                                <select name="status" class="form-control  " required>
                                    <option value="">Choose Status</option>
                                    <option value="public" {{ $category['status'] == 'public' ? 'selected' : '' }}>Public</option>
                                    <option value="private" {{ $category['status'] == 'private' ? 'selected' : '' }}> Private
                                    </option>

                                </select>
                                <span class="text-danger size-nm"> @error('status')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>



                        <tr>
                            <input type="hidden" value="{{ $category['id'] }}" name="id">
                            <td colspan="2" class="text-right">
                                <input type="submit" name="submit" class="btn btn-sm cbtn float-end size-nm" value="SUBMIT">
                            </td>
                        </tr>



                    </table>




                </form>
            </div>
        </div>
    </div>






</div>
@section('script')
    <script type="text/javascript">
        $("#sideproducts").addClass("sidelinkactive");
    </script>
@endsection




@endsection
