@extends('admin.adminmaster')
@section('title')
    Admin-Categories
@endsection

@section('content')
@section('heading')
    Categories
@endsection

<div class="row">
    <div class="col-md-12">
        @if (session('category_msg'))
        @if (session('category_msg') == 'true')
            <br>
            <div class="alert alert-success alert-dismissible fade show size-nm" role="alert">
                <strong> Success! </strong> Category has been Added Successfully
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
        @else
            <div class="alert alert-danger alert-dismissible fade show size-nm" role="alert">
                <strong> Failed! </strong> Some Issue Occured. Try Again
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
    @endif
        <div class="card">
            <div class="card-header"><h6> Add new Category </h6></div>
            <div class="card-body">
                <h6> Fill the Required Fields</h6>

                <form method="post" class="size-sm" action="{{ route('savecategory') }}" enctype="multipart/form-data">
                    @csrf
                    <table class="table table-sm table-sm-responsive size-sm form-table">
                        <tr>
                            <td width="15%">
                                <h6 class="size-nm form-label">Category Name: </h6>
                            </td>
                            <td>
                                <input type="text" id="name" name="name" value="{{ old('name') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Category Name...">
                                <span class="text-danger size-nm"> @error('name')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Category Priority: </h6>
                            </td>
                            <td>
                                <input type="text" id="priority" name="priority" value="{{ old('priority') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Category Priority...">
                                <span class="text-danger size-nm"> @error('priority')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Category Status </h6>
                            </td>
                            <td>
                                <select name="status"  class="form-control ">
                                    <option value="">Choose Status</option>
                                    <option value="private">Private</option>
                                    <option value="public"> Public </option>
                                </select>
                                <span class="text-danger size-nm"> @error('status')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>


                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Short Description: </h6>
                            </td>
                            <td>
                                <input type="text" id="priority" name="short_description" value="{{ old('short_description') }}"
                                    class="form-control ctextfield size-nm" placeholder="Enter Short Description...">
                                <span class="text-danger size-nm"> @error('short_description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h6 class="size-nm form-label">Category Description </h6>
                            </td>
                            <td>
                                <textarea class=" ctextfield size-nm form-control" name="description" rows="2" placeholder="Category Description">{{ old('description') }}</textarea>
                                <span class="text-danger size-nm"> @error('description')
                                        {{ $message }}
                                    @enderror
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-right">
                                <input type="submit" name="submit" class="btn btn-sm btn-primary  float-end size-nm" value="SUBMIT">
                            </td>
                        </tr>



                    </table>




                </form>

            </div>
        </div>
    </div>






</div>
@section('script')
    <script type="text/javascript">
        $("#sidecateg").addClass("sidelinkactive");
    </script>
@endsection




@endsection
