<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string("order_no")->unique();
            $table->float("total_price");
            $table->string("status")->nullable();//pending,processing,done
            $table->dateTime("deliveredDate");
            $table->string("email")->nullable();
            $table->string("name")->nullable();
            $table->string("phone")->nullable();
            $table->string("phone2")->nullable();
            $table->string("city")->nullable();
            $table->string("street")->nullable();
            $table->string("postal_code")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
