<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\product;
use App\Http\Controllers\CategoryController;
class ListingController extends Controller
{
    //
    public function products(Request $req,$categ="")
    {
        $category=new CategoryController();
        $categories=$category->public_categories();

        $response=$this->make_filter($req,$categ);
       $products=product::join("categories","categories.id","=","products.category_id")
        ->selectRaw("products.id,products.name,products.price,products.final_price,products.discount,products.code,products.photo,products.created_at, (select sum(stars) from reviews where reviews.product_id=products.id)/(select count(*) from reviews where reviews.product_id=products.id) as stars")
        ->whereRaw("products.status='public' "." ".$response['query'])->orderByRaw($response['sorting'])->paginate(30);
       $inputs="";
       $inputs=$req->sort_by ?? '';
        return view("user.allproducts", ['products'=>$products,'parameters'=>$response['params'],'sorting'=>$inputs,"categories"=>$categories]);
    }

    public function make_filter(Request $req,$categ)
    {
        $sorting = "created_at desc";
        $counter=0;
        $params=array();
        $q="";
        if($categ!="")
        {
            $q=$q." and categories.code='".$categ."'";

            $params['category'] = $categ;
        }
        if($req->input("search") && $req->input("search")!="")
        {

            $q=$q." and (products.name like '%".$req->input("search")."%' or  products.description like '%".$req->input("search")."%' or  products.short_description like '%".$req->input("search")."%') ";

            $params['search'] = $req->search;
        }
        if($req->input("sort_by") && $req->input("sort_by")!="")
        {
            $exp = explode("_",$req->input("sort_by"));
            if(sizeof($exp)>1)
            {
            if($exp[1]=="asc" || $exp[1]=="desc"){

                if($exp[0] == "alphabatic")
                {
                    $sorting = "name ".$exp[1];
                }
                else if($exp[0] == "price")
                {
                    $sorting = "final_price ".$exp[1];
                }
                else if($exp[0] == "date")
                {
                    $sorting = "created_at ".$exp[1];
                }

            }
        }
        }


        return ['query'=>$q,"params"=>$params,"sorting"=>$sorting];
    }
}
