<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\category;
class CategoryController extends Controller
{
    public function categories(Request $req)
    {
       
       
        return view("admin.categories.categories",['categories'=>category::all()]);
    }

    public function addcategory()
    {
        return view("admin.categories.addcategory");
    }

    public function public_categories()
    {
        return category::where("status","public")->select("name","code")->get();
    }

    public function getMaxId()
    {
        return 1+category::max("id");
    }

    public function savecategory(Request $req)
    {
        $req->validate([
            'name'=>'required|max:90|min:2',
            'priority'=>'required|numeric:10000000|min:1',
            'status'=>'required',


            'description'=>'max:150',
            'short_description'=>'min:0|max:90'
        ]);
        $category=new category();
        $category->name=$req->input("name");
        $category->code="category_".$this->getMaxId();
        $category->priority=$req->input("priority");
        $category->status=$req->input("status");
        $category->description=$req->input("description");
        $category->short_description=$req->input("short_description");

        if($category->save())
        {
            $req->session()->flash("category_msg","true");
            return redirect()->back();
        }
        else
        {
            $req->session()->flash("category_msg","false");
            return redirect()->back();
        }


    }
    public function update_status(Request $req,$id,$public)
    {
          $categ=category::find($id);
          $categ->status=$public;
          if($categ->save())
          {
            $req->session()->flash("category_msg","true");
            return redirect()->back();
        }
        else
        {
            $req->session()->flash("category_msg","false");
            return redirect()->back();
        }


    }
    public function update_status_private(Request $req,$id,$private)
    {
          $categ=category::find($id);
          $categ->status=$private;
          if($categ->save())
          {
            $req->session()->flash("category_msg","true");
            return redirect()->back();
        }
        else
        {
            $req->session()->flash("category_msg","false");
            return redirect()->back();
        }


    }

    public function edit_category($id)
    {
        $category = category::find($id);

        return view("admin.categories.edit_category", ['category' => $category]);
    }
    public function editcategory(Request $req)
    {
        $req->validate([
            'name'=>'required|max:90|min:2',
            'priority'=>'required|numeric:10000000|min:1',
            'status'=>'required',



        ]);
        $category=category::find($req->input('id'));

        $category->name=$req->input("name");

        $category->priority=$req->input("priority");
        $category->status=$req->input("status");


        if($category->save())
        {
            $req->session()->flash("category_msg","true");
            return redirect()->back();
        }
        else
        {
            $req->session()->flash("category_msg","false");
            return redirect()->back();
        }


    }

}
