<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\cart;
use App\Models\product;
use App\Models\product_size;
use App\Models\state;
use App\Models\city;
use App\Models\unit;

class CartController extends Controller
{

    public function add_to_cart(Request $req)
    {
        if ($req->session()->has("cart_access_token"))
        {
            $token=session("cart_access_token");

        }
        else
        {
            $token=substr(str_shuffle('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'), 1, 7);
            $req->session()->put("cart_access_token",$token);
        }
         $req->validate([
             'unit'=>'nullable',
               'size'=>'nullable',
         ]);
        $cart = new cart();
        $product = product::where("code", $req->pid)->first();
        $unit_price=unit::where('product_id',$product->id)->where('unit',$req->unit)->first();
        $cart->product_id = $product->id;
        $cart->color = $req->color;
        $cart->size = $req->size;
        $cart->unit = $req->unit;
        $cart->quantity = $req->quantity;
        $cart->price = $product->final_price;
        $cart->total_amount = $product->final_price*$req->quantity;
        $cart->discount = $product->discount;
        $cart->token=$token;
        if($cart->save())
        {


            $this->getCartQuantity($req);
            session()->put('totalprice', $cart['total_amount']);
            if($req->submit=="Buy  Now")
            {
                return redirect()->route('checkout');
            }else{
                return redirect()->back()->with(['cart_msg'=>'Your item has been successfully added to the cart. Happy shopping!']);
            }
        }
        else
        {
            return redirect()->back()->with(['cart_msg'=>'A problem occured Please Try Again Later']);
        }
    }

    public function user_cart(Request $req)
    {
        $cart=array();
        if($req->session()->has("cart_access_token"))
        {
            $cart=cart::where("token",session("cart_access_token"))->with("getProduct")->get();
        }

        return view("user.user_cart2",['carts'=>$cart]);
    }

    public function checkout(Request $req)
    {
        $cart=array();
        if($req->session()->has("cart_access_token"))
        {
            $cart=cart::where("token",session("cart_access_token"))->with("getProduct")->get();
        }
       // return $cart;
        $state=state::all();
        if($req->session()->has("cart_access_token"))
        {
            return view("user.checkout2",['carts'=>$cart,'states'=>$state]);
        }
        else
        {
            return ['Message'=>'Permission Not Granted'];
        }


    }
    public function getcities($state){

$cities=city::where('state',$state)->get();
return $cities;
    }

    public function getCartQuantity(Request $req)
    {
        if($req->session()->has("cart_access_token"))
        {
            $sum=cart::where("token",session("cart_access_token"))->count();
            if($sum>=1){
            $req->session()->put("cart_quantity",$sum);
            }
            else
            {
                if($req->session()->has("cart_quantity")){
                $req->session()->pull("cart_quantity");
            }
            }
        }
        else
        {
            if($req->session()->has("cart_quantity")){
                $req->session()->pull("cart_quantity");
            }
        }
    }

    public function update_cart_quantity(Request $req)
    {
        if(($req->quantity!="") && ($req->quantity>=1) && ($req->session()->has("cart_access_token")))
        {
            $cart=cart::where("token",session("cart_access_token"))->where("product_id",$req->pid)->first();
            if($cart)
            {
                $cart->quantity=$req->quantity;
                $cart->total_amount=$req->quantity*$cart->price;
                if($cart->save())
                {
                    return redirect()->back()->with(['cart_update_status'=>'Cart has been updated']);
                }
                else
                {
                    return redirect()->back()->with(['cart_update_status'=>'Cart Was not updated. Try Again3']);
                }
            }
            else
            {
                return redirect()->back()->with(['cart_update_status'=>'Cart Was not updated. Try Again2']);
            }
        }
        else
        {
            return redirect()->back()->with(['cart_update_status'=>'Cart Was not updated. Try Again1']);
        }
    }


    public function delete_cart(Request $req)
    {
        if($req->session()->has("cart_access_token"))
        {
            cart::where("token",session("cart_access_token"))->where("product_id",$req->pid)->delete();
            $this->getCartQuantity($req);
            return redirect()->back();
        }
    }
}
