@extends('user.usermaster2')

@section('title', 'Product')
@section("meta_title") Painfree Australia - {{ Str::upper($product['name']) }} -Product @endsection

@section("meta_desc")  {{ $product['short_description'] }}@endsection
@section("meta_keywords") {{ $product['short_description'] }}, Painfree-australia products,PainFree, Australia, Austriala Painfree, Products painfree, product painfree australia,Posture Corrector,Back Support,Back Brace,Posture Clavicle support,Shoulder Brace Back Support,Shoulder support,shoulder brace,Adjustable posture corrector back support,Knee support,Knee Sleeve,Knee brace,compression knee support,Compression knee sleeve,arthritis knee support,arthritis knee Brace,arthritis knee sleeve,best Knee support,Adjustable Knee Sleeve,Copper knee support,Knee Arthritis Compression Sleeve,Knee Patella Support,Patella Gel Pad,Foot and Ankle compression socks,Foot compression socks,Foot Compression sleeve,Plantar Fasciitis compression socks,Night Splint Socks,Ankle compression socks,Ankle compression sleeve,Compression Ankle Support,Compression Ankle Brace,Compression Ankle Sleeves,Ankle support,Ankle Wrap,Ankle Brace Support,Ankle Stabilizer,Ankle Strap support,Foot Stretching socks,Ankle Brace Stabilizer Ankle Support,Anti-fatigue socks,Anti-fatigue compression socks,Leg ease compression Socks,Adjustable Foot & ankle splint,Arthritis Gloves,Wrist compression Sleeve,Hand compression sleeve,Magnetic Arthritis Gloves,Wrist pain Support,Wrist Stabilizer,Thumb Splint,Thumb Brace,Thumb support,Copper Hand and wrist support,Therapeutic heat gloves,Compression arthritis gloves,Compression gloves,Magnetic Gloves,Copper wrist and Hand Compression Sleeve,Abdominal Binder Belt,Waist Belt,Hernia belt,Umbilical Hernia Abdominal Binder Belt,Medical umbilical hernia belt,painfree australia,australia painfree, painfree australia products, painfree products,painfree australia, best painfree australia,best painfree australia products,best painfree products  @endsection

@section('style')
<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins&display=swap');


.star-widget input {
    display: none;
}

.star-widget label {
    font-size: 35px;
    color: #444;
    padding: 10px;
    float: right;
    transition: all .2s ease;
}
input:not(:checked) ~ label:hover,
input:not(:checked) ~ label:hover ~ label {
    color: #fd4;
}

input:checked ~ label {
    color: #fd4;
    
}

#rate-1:checked ~ .rating-desc:before {
    content: "Poor";
}
#rate-2:checked ~ .rating-desc:before {
    content: "Not bad";
}
#rate-3:checked ~ .rating-desc:before {
    content: "Average";
}
#rate-4:checked ~ .rating-desc:before {
    content: "Good😋";
}
#rate-5:checked ~ .rating-desc:before {
    content: "Excellent😋";
}

 .rating-desc {
    width: 100%;
    font-size: 20px;
    font-weight: 600;
    margin: 5px 0 20px 0;
    text-align: center;
    transition: all .2s ease;
}

.star-rating-bx {
    background-color: #fff;
    box-shadow: 0px 4px 40px 0px rgb(0 0 0 / 5%);
    border-radius: 10px;
    padding: 40px;
}
@media (max-width:576px) {
    .star-rating-bx {
        padding:20px 15px;
    }
}

.star-icon {
    padding-bottom: 20px;
}
.modal-title {
    font-weight: 600;
}
#error-comment,
#error-rating {
    color: red;
}
.star{
    color:#fec348;
}

</style>
@endsection


@section('body')

    <main>
        <div class="container margin_30">
            <div class="row">
                <div class="col-md-12">
                    <h4>View Product</h4>
                    @if (session('cart_msg'))
                        <br>
                        <div class="alert alert-info alert-dismissible fade show" role="alert">
                            <strong>Message</strong> {{ session('cart_msg') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-md-6 p-3">
                    <div class="img-div border ">
                        <div id="carouselExampleControls" class="carousel slide" class="bg-dark" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                <div class="carousel-item active">

                                    <center><img src="{{ asset($product->photo) }}" class="img img-fluid"
                                            style="height: 300px;width:310" alt="..."></center>
                                </div>
                                @foreach ($product->getimages as $image)
                                    <div class="carousel-item ">

                                        <center> <img src="{{ asset($image->images) }}" class="img img-fluid"
                                                style="height: 300px;width:310" alt="..."></center>
                                    </div>
                                @endforeach

                            </div>
                            <button class="carousel-control-prev text-dark" type="button"
                                data-bs-target="#carouselExampleControls" data-bs-slide="prev">
                                <i class="fa-solid fa-arrow-left size-vlg"></i>
                            </button>
                            <button class="carousel-control-next  text-dark" type="button"
                                data-bs-target="#carouselExampleControls" data-bs-slide="next">
                                <i class="fa-solid fa-arrow-right size-vlg"></i>
                            </button>
                        </div>

                    </div><br>


                </div>
                <div class="col-md-6">

                    <!-- /page_header -->
                    <div class="prod_info">
                        <form method="post" action="{{ route('add_to_cart') }}">
                            @csrf
                            <input type="hidden" id="pid" name="pid" value="{{ $product->code }}">
                            <input type="hidden" id="proid" name="proid" value="{{ $product->id }}">
                            <h1>{{ Str::upper($product['name']) }}</h1>
                            @php $rating = $stars ?? 5;@endphp
<div class="rating">
    <i class="fa-solid star {{ $rating >= 1 ? 'fa-star' : ($rating >= 0.5 ? ' fa-star-half-stroke' : '') }}"></i>
    <i class="fa-solid star {{ $rating >= 2 ? 'fa-star' : ($rating >= 1.5 ? ' fa-star-half-stroke' : '') }}"></i>
    <i class="fa-solid star {{ $rating >= 3 ? 'fa-star' : ($rating >= 2.5 ? ' fa-star-half-stroke' : '') }}"></i>
    <i class="fa-solid star {{ $rating >= 4 ? 'fa-star' : ($rating >= 3.5 ? ' fa-star-half-stroke' : '') }}"></i>
    <i class="fa-solid star {{ $rating >= 5 ? 'fa-star' : ($rating >= 4.5 ? ' fa-star-half-stroke' : '') }}"></i>
</div>
                            <!--<span class="rating">-->
                               
                            <!--   @for($i = 1; $i <= round($stars); $i++)-->
                            <!--       <i class="icon-star voted"></i>-->
                            <!--    @endfor-->
                               
                                
                            <!--   <em class="text-dark"> {{$stars }} Stars</em></span>-->
                            <!--<div class="Stars" style="--rating: {{ round($stars, 2) }};"><span class="text-dark">{{$stars}} Stars</span>-->
                            <!--<span class="rating"><i class="icon-star voted"></i></span>-->
                            
                            
                               
                            
                            <h6 class=" mt-3" style="color:#004dda">🚚 FAST & FREE SHIPPING AUSTRALIA WIDE</h6>
                            <h6  style="color:red"> 🚚 Get Free Express Postage If Buy More Than 1x Item
                            </h6>

                            <p> {{ $product['short_description'] }}</p>
                            <div class="prod_options">
                                {{-- <div class="row">
                                    <label class="col-xl-5 col-lg-5  col-md-6 col-6 pt-0"><strong>Available</strong></label>
                                    <div class="col-xl-4 col-lg-5 col-md-6 col-6 colors">
                                        <ul>
                                            <p>{{ $product->quantity }}</p>

                                        </ul>
                                    </div>
                                </div> --}}

                                <div class="row">
                                    <label class="col-xl-5 col-lg-5  col-md-6 col-6 pt-0"><strong>Color</strong></label>
                                    <div class="col-xl-4 col-lg-5 col-md-6 col-6 colors">
                                        <ul>
                                            @foreach ($product['getColors'] as $color)
                                                <li><a data-color="{{ $color->color }}"  @if(sizeof($product['getColors'])==1) class='color active' @else class='color' @endif 
                                                        style="background-color:{{ $color['color_code'] }};border:1px solid black"></a>
                                                </li>
                                            @endforeach
                                            {{-- <li><a href="#0" class="color color_2"></a></li>
                                    <li><a href="#0" class="color color_3"></a></li>
                                    <li><a href="#0" class="color color_4"></a></li> --}}
                                        </ul>
                                    </div>
                                </div>
                                <div class="row">
                                     
                                    <label for="select1" class="col-xl-5 col-lg-5 col-md-6 col-6"><strong>Size <span class='text-danger'>*</span></strong> </label>
                                   
                                    <div class="col-xl-4 col-lg-5 col-md-6 col-6">
                                        <div class="custom-select-form">
                                             @if (sizeof($product->getSizes) >= 1)
                                            <select name="size" id="select1" class="wide size-sm ctextfield" >
                                                @else
                                                 <select name="size" id="select1" class="wide size-sm ctextfield">
                                                @endif
                                                @if (sizeof($product->getSizes) >= 1)
                                                    <option value="">Choose Size</option>
                                                @else
                                                    <option value="">Non Sized</option>
                                                @endif
                                                @foreach ($product->getSizes as $size)
                                                    <option value="{{ $size->size }}">{{ $size->size }}</option>
                                                @endforeach
                                            </select>
                                             <span class="size-nm text-danger">@error('size') {{ $message }}   @enderror</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <label class="col-xl-5 col-lg-5 col-md-6 col-6"><strong>Pack Size</strong> </label>
                                    <div class="col-xl-4 col-lg-5 col-md-6 col-6">
                                        <div class="custom-select-form">
                                            <select name="unit" id="unit" onchange="get_unit()" class="wide size-sm ctextfield">
                                                @if(isset($product->get_units))
                                                @if (sizeof($product->get_units) >= 1)

                                                @else
                                                    <option value="">Non Pack Size</option>
                                                @endif
                                                @foreach ($product->get_units as $size)
                                                    <option value="{{ $size->unit }}">{{ $size->unit }}</option>
                                                @endforeach
                                                @endif
                                            </select>

                                            <span class="text-danger">
                                                @error('unit')
                                                    {{ $message }}
                                                @enderror
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <label
                                        class="col-xl-5 col-lg-5  col-md-6 col-6"><strong>{{ isset($product->unit) ? $product->unit : 'Quantity' }}</strong></label>
                                    <div class="col-xl-4 col-lg-5 col-md-6 col-6">
                                        <div class="numbers-row2">
                                            <input type="text" name="quantity" min="1"
                                                max="{{ $product->quantity }}" required value="1"
                                                class="qty2 form-control">
                                        </div>
                                        <span></span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-5 col-md-6">
                                    <div class="price_main"><span class="new_price">${{ isset($product['get_units'][0]['final_price']) ? $product['get_units'][0]['final_price']: 'N/A' }}</span>
                                    

                                        @if (isset($product['get_units'][0]['discount']) ? $product['get_units'][0]['discount']: 'N/A'  != 0)
                                            {{-- @php
                                $price= $product->price;
                                $discount=$product->final_price;
                                $safe=$price-$discount;
                                @endphp --}}
                                            <!--<span class="percentage">-{{ isset($product['get_units'][0]['discount']) ? $product['get_units'][0]['discount']: 'N/A' }}%</span>-->
                                            <span class="old_price fw-bold">${{ isset($product['get_units'][0]['price']) ? $product['get_units'][0]['price']: 'N/A' }}</span>
                                        @endif
                                    </div>
                                </div>
                               
                                    <div class="col-lg-4 col-md-6">
                                        <input type="hidden" name="color" id="color">
                                        <div class="btn_add_to_cart"><input class="btn_1" type="submit" name="submit"
                                                value="Add to Cart"></div>
                                    </div>
                                
                            </div>
                        </form>
                        <br>
                        <h6  style="color:red"> SAME DAY DISPATCH FROM MELBOURNE
                            </h6>
                            <br><br>
                            <h4 class="text-center">100% Secure Australian Checkout<br>
                            <img src="{{asset('assets/img/new_crds.png')}}" class="img img-fluid" style="height:60px;width:380px"></h4>
                            
                    </div>
                    <!-- /prod_info -->
                    {{-- <div class="product_actions">
                    <ul>
                        <li>
                            <a href="#"><i class="ti-heart"></i><span>Add to Wishlist</span></a>
                        </li>
                        <li>
                            <a href="#"><i class="ti-control-shuffle"></i><span>Add to Compare</span></a>
                        </li>
                    </ul>
                </div> --}}
                    <!-- /product_actions -->
                </div>
            </div>
            <!-- /row -->
        </div>
        <!-- /container -->

        <div class="tabs_product">
            <div class="container">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a id="tab-A" href="#pane-A" class="nav-link active" data-bs-toggle="tab"
                            role="tab">Description</a>
                    </li>
                    <li class="nav-item">
                        <a id="tab-B" href="#pane-B" class="nav-link" data-bs-toggle="tab"
                            role="tab">Reviews</a>
                    </li>
                </ul>
            </div>
        </div>
        <!-- /tabs_product -->
        <div class="tab_content_wrapper">
            <div class="container">
                <div class="tab-content" role="tablist">
                    <div id="pane-A" class="card tab-pane fade active show" role="tabpanel" aria-labelledby="tab-A">
                        <div class="card-header" role="tab" id="heading-A">
                            <h5 class="mb-0">
                                <a class="collapsed" data-bs-toggle="collapse" href="#collapse-A" aria-expanded="false"
                                    aria-controls="collapse-A">
                                    Description
                                </a>
                            </h5>
                        </div>
                        <div id="collapse-A" class="collapse" role="tabpanel" aria-labelledby="heading-A">
                            <div class="card-body">

                                <div class="row justify-content-between">
                                    <div class="col-lg-12">

                                        <p><?= $product['description'] ?></p>

                                    </div>
                                    {{-- <div class="col-lg-5">
                                    <h3>Specifications</h3>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-striped">
                                            <tbody>
                                                <tr>
                                                    <td><strong>Color</strong></td>
                                                    <td>Blue, Purple</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Size</strong></td>
                                                    <td>150x100x100</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Weight</strong></td>
                                                    <td>0.6kg</td>
                                                </tr>
                                                <tr>
                                                    <td><strong>Manifacturer</strong></td>
                                                    <td>Manifacturer</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- /table-responsive -->
                                </div> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /TAB A -->
                    <div id="pane-B" class="card tab-pane fade" role="tabpanel" aria-labelledby="tab-B">
                        <div class="card-header" role="tab" id="heading-B">
                            <h5 class="mb-0">
                                <a class="collapsed" data-bs-toggle="collapse" href="#collapse-B" aria-expanded="false"
                                    aria-controls="collapse-B">
                                    Reviews
                                </a>
                            </h5>
                        </div>
                        @include('user.reviews')
                        <div id="collapse-B" class="collapse" role="tabpanel" aria-labelledby="heading-B">
                            <div class="card-body">
                                <div class="row justify-content-between">
                                    @foreach ($product->getReviews as $review)
                                        <div class="col-lg-6">
                                            <div class="review_content">
                                                <div class="clearfix add_bottom_10">

                                                    <em>{{ \Carbon\Carbon::parse($review->created_at)->diffForHumans() }}</em>
                                                </div>
                                                
                                                <p class="mb-0">"{{ $review->review }}"</p>
                                                
                                                 <p class="rating mt-0 "><i class="icon-star voted"></i><span class="text-dark">{{$review->stars}} Stars</span></p>
                                                 <br>
                                                
                                                <p class="mt-2"> 
                                                <img class="img fluid rounded-circle" height="50px"
                                                        src="{{ asset('static/avatars/av1.jpg') }}"> {{ $review->name }}   
                                                </p>
                                                
                                            </div>
                                        </div>
                                    @endforeach

                                </div>
                                <!-- /row -->


                               
                            </div>
                            <!-- /card-body -->
                        </div>
                    </div>
                    <!-- /tab B -->
                </div>
                <hr>
                <!-- /tab-content -->
            </div>
            <!-- /container -->
        </div>
        <!-- /tab_content_wrapper -->
        
         <div class="container margin_60_35">
        <div class="main_title">
            <h2>Related Products</h2>
           
            <!--<p>Purchase More Quality Stuff.</p>-->
        </div>
        <div class="owl-carousel owl-theme products_carousel owl-loaded owl-drag">

            <div class="owl-stage-outer">
                <div class="owl-stage"
                    style="transform: translate3d(-219px, 0px, 0px); transition: all 0s ease 0s; width: 1097px;">
                    @foreach ($related_products as $product)
                        <div class="owl-item active" style="width: 209.333px; margin-right: 10px;">
                            <div class="item">
                                <div class="grid_item">
                                    <!--<span class="ribbon new">New</span>-->
                                    <figure>
                                        <a href="/viewproduct/{{ $product['code'] }}">
                                            <img class="img-fluid " src="{{ asset($product['photo']) }}"
                                                data-src="{{ asset($product['photo']) }}" alt="">
                                            <img class="img-fluid " src="{{ asset($product['photo']) }}"
                                                data-src="{{ asset($product['photo']) }}" alt="">
                                        </a>
                                    </figure>

                                    <a href="/viewproduct/{{ $product['code'] }}">
                                        <h2 class="size-lg">{{ Str::upper($product['name']) }}</h2>
                                    </a>
                                    @php $rating = $product->stars ?? 5 ;@endphp
                                    <div class="rating">
                                        <i
                                            class="fa-solid star {{ $rating >= 1 ? 'fa-star' : ($rating >= 0.5 ? ' fa-star-half-stroke' : '') }}"></i>
                                        <i
                                            class="fa-solid star {{ $rating >= 2 ? 'fa-star' : ($rating >= 1.5 ? ' fa-star-half-stroke' : '') }}"></i>
                                        <i
                                            class="fa-solid star {{ $rating >= 3 ? 'fa-star' : ($rating >= 2.5 ? ' fa-star-half-stroke' : '') }}"></i>
                                        <i
                                            class="fa-solid star {{ $rating >= 4 ? 'fa-star' : ($rating >= 3.5 ? ' fa-star-half-stroke' : '') }}"></i>
                                        <i
                                            class="fa-solid star {{ $rating >= 5 ? 'fa-star' : ($rating >= 4.5 ? ' fa-star-half-stroke' : '') }}"></i>
                                    </div>
                                    <div class="price_box">
                                        @foreach ($product->get_units as $unit)
                                            @if ($unit->is_visible_main_price == 'yes')
                                                <label
                                                    class="new_price fw-bold text-primary">${{ $unit['final_price'] }}</label>
                                                @if ($unit['discount'] != 0)
                                                    <span class="old_price fw-bold">${{ $unit['price'] }}</span>
                                                @endif
                                            @endif
                                        @endforeach
                                    </div>

                                </div>
                                
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
            <div class="owl-nav ">
                <button type="button" role="presentation" class="owl-prev"><i
                        class="ti-angle-left"></i></button>
                        <button type="button" role="presentation"
                    class="owl-next "><i class="ti-angle-right"></i>
                    </button>
                    </div>
            
            
        </div>
        
    </div>
        


        <!-- /container -->

        <div class="feat">
            <div class="container">
                <ul>
                    <li>
                        <div class="box">
                            <i class="ti-gift"></i>
                            <div class="justify-content-center">
                                <h3>Free And Fast Delivery Australia Wide</h3>
                                <p></p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="box">
                            <i class="ti-wallet"></i>
                            <div class="justify-content-center">
                                <h3>Secure Payment</h3>
                                <p>100% secure payment</p>
                            </div>
                        </div>
                    </li>
                    <li>
                        <div class="box">
                            <i class="ti-headphone-alt"></i>
                            <div class="justify-content-center">
                                <h3>Online top support</h3>

                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
        <!--/feat-->

    </main>



@endsection

@section('scripts')
    <script>
        $(".color").click(function() {


            //   alert($(this).attr("data-color"));
            $(".color").removeClass("active");
            var check = $(this).hasClass('active');
            if (check) {
                $(this).removeClass("active");
            } else {
                $(this).addClass('active');
                $("#color").val($(this).attr("data-color"));
            }


        })



    </script>
    <script>
         function get_unit() {
            var unit = $('#unit').val();
            var id = $('#proid').val();
            //console.log(id);
            $.ajax({
            url: "/getunit/"+unit+"/"+id,
            type: "GET",
            data: {
                data: "data"
            },
            success: function(units) {

                //console.log(units);

               //var old= $(".new_price").html();
               $(".new_price").html("");
               
               $(".new_price").html("$"+units.final_price);
                $(".old_price").html("");
                $(".old_price").html("$"+units.price);



            }
        });
        }
    </script>
    <script>
       function feedBack() {

    var rating_Count = document.querySelector("input[name=star]:checked").value;
    console.log(rating_Count);
   
    $('#star_count').val( rating_Count);
  }
    </script>

@endsection
